/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.internal.browse;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class P2BrowseNodeGeneratorHelper {
    private static final Set<String> knownSubDirectories = ImmutableSet.of((Object)"binary", (Object)"features", (Object)"plugins");

    private P2BrowseNodeGeneratorHelper() {
    }

    public static List<String> computeComponentPath(List<String> assetPath, Optional<String> nameOptional, Optional<String> versionOptional) {
        ArrayList<String> pathParts = new ArrayList<String>();
        if (assetPath.size() > 1) {
            pathParts.add(assetPath.get(0));
        }
        nameOptional.ifPresent(name -> {
            String version = (String)versionOptional.orElseThrow(() -> new IllegalStateException("Supplied component name, but not version"));
            if (!knownSubDirectories.contains(assetPath.get(0))) {
                pathParts.add((String)assetPath.get(1));
            }
            pathParts.addAll(Splitter.on((char)'.').omitEmptyStrings().splitToList((CharSequence)name));
            pathParts.add(version);
        });
        return pathParts;
    }

    public static List<String> splitPath(String path) {
        return Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)path);
    }
}

