/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.datastore.internal.proxy;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.p2.AssetKind;
import com.sonatype.nexus.repository.p2.datastore.P2ContentFacet;
import com.sonatype.nexus.repository.p2.datastore.internal.proxy.P2ProxyCacheInvalidatorFacet;
import com.sonatype.nexus.repository.p2.datastore.internal.proxy.P2ProxyFacet;
import com.sonatype.nexus.repository.p2.internal.security.P2SecurityFacet;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.RecipeSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.NegativeCacheFacet;
import org.sonatype.nexus.repository.cache.NegativeCacheHandler;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.maintenance.LastAssetMaintenanceFacet;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.repository.http.HttpHandlers;
import org.sonatype.nexus.repository.http.PartialFetchHandler;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.proxy.ProxyHandler;
import org.sonatype.nexus.repository.purge.PurgeUnusedFacet;
import org.sonatype.nexus.repository.recipe.RouterBuilder;
import org.sonatype.nexus.repository.routing.RoutingRuleHandler;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.handlers.ConditionalRequestHandler;
import org.sonatype.nexus.repository.view.handlers.ContentHeadersHandler;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.LastDownloadedHandler;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;
import org.sonatype.nexus.repository.view.matchers.ActionMatcher;
import org.sonatype.nexus.repository.view.matchers.logic.LogicMatchers;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@AvailabilityVersion(from="1.0")
@Named(value="p2-proxy")
@Singleton
public class P2ProxyRecipe
extends RecipeSupport {
    public static final String NAME = "p2-proxy";
    private final Provider<ConfigurableViewFacet> viewFacet;
    private final Provider<HttpClientFacet> httpClientFacet;
    private final Provider<NegativeCacheFacet> negativeCacheFacet;
    private final Provider<P2ContentFacet> contentFacet;
    private final Provider<P2ProxyCacheInvalidatorFacet> cacheInvalidatorFacet;
    private final Provider<P2ProxyFacet> proxyFacet;
    private final Provider<P2SecurityFacet> securityFacet;
    private final Provider<PurgeUnusedFacet> purgeUnusedFacet;
    private final Provider<SearchFacet> searchFacet;
    private final Provider<LastAssetMaintenanceFacet> maintenanceFacet;
    private final Provider<BrowseFacet> browseFacet;
    private final ConditionalRequestHandler conditionalRequestHandler;
    private final ContentHeadersHandler contentHeadersHandler;
    private final ExceptionHandler exceptionHandler;
    private final HandlerContributor handlerContributor;
    private final NegativeCacheHandler negativeCacheHandler;
    private final PartialFetchHandler partialFetchHandler;
    private final ProxyHandler proxyHandler;
    private final RoutingRuleHandler routingRuleHandler;
    private final SecurityHandler securityHandler;
    private final TimingHandler timingHandler;
    private final LastDownloadedHandler lastDownloadedHandler;

    @Inject
    public P2ProxyRecipe(@Named(value="proxy") @Named(value="proxy") Type type, @Named(value="p2") @Named(value="p2") Format format, Provider<ConfigurableViewFacet> viewFacet, Provider<HttpClientFacet> httpClientFacet, Provider<NegativeCacheFacet> negativeCacheFacet, Provider<P2ContentFacet> contentFacet, Provider<P2ProxyCacheInvalidatorFacet> cacheInvalidatorFacet, Provider<P2ProxyFacet> proxyFacet, Provider<P2SecurityFacet> securityFacet, Provider<PurgeUnusedFacet> purgeUnusedFacet, Provider<SearchFacet> searchFacet, Provider<LastAssetMaintenanceFacet> maintenanceFacet, Provider<BrowseFacet> browseFacet, ConditionalRequestHandler conditionalRequestHandler, ContentHeadersHandler contentHeadersHandler, ExceptionHandler exceptionHandler, HandlerContributor handlerContributor, NegativeCacheHandler negativeCacheHandler, PartialFetchHandler partialFetchHandler, ProxyHandler proxyHandler, RoutingRuleHandler routingRuleHandler, SecurityHandler securityHandler, TimingHandler timingHandler, LastDownloadedHandler lastDownloadedHandler) {
        super(type, format);
        this.viewFacet = (Provider)Preconditions.checkNotNull(viewFacet);
        this.httpClientFacet = (Provider)Preconditions.checkNotNull(httpClientFacet);
        this.negativeCacheFacet = (Provider)Preconditions.checkNotNull(negativeCacheFacet);
        this.contentFacet = (Provider)Preconditions.checkNotNull(contentFacet);
        this.cacheInvalidatorFacet = (Provider)Preconditions.checkNotNull(cacheInvalidatorFacet);
        this.proxyFacet = (Provider)Preconditions.checkNotNull(proxyFacet);
        this.securityFacet = (Provider)Preconditions.checkNotNull(securityFacet);
        this.purgeUnusedFacet = (Provider)Preconditions.checkNotNull(purgeUnusedFacet);
        this.searchFacet = (Provider)Preconditions.checkNotNull(searchFacet);
        this.maintenanceFacet = (Provider)Preconditions.checkNotNull(maintenanceFacet);
        this.browseFacet = (Provider)Preconditions.checkNotNull(browseFacet);
        this.conditionalRequestHandler = (ConditionalRequestHandler)Preconditions.checkNotNull((Object)conditionalRequestHandler);
        this.contentHeadersHandler = (ContentHeadersHandler)Preconditions.checkNotNull((Object)contentHeadersHandler);
        this.exceptionHandler = (ExceptionHandler)Preconditions.checkNotNull((Object)exceptionHandler);
        this.handlerContributor = (HandlerContributor)Preconditions.checkNotNull((Object)handlerContributor);
        this.negativeCacheHandler = (NegativeCacheHandler)Preconditions.checkNotNull((Object)negativeCacheHandler);
        this.partialFetchHandler = (PartialFetchHandler)Preconditions.checkNotNull((Object)partialFetchHandler);
        this.proxyHandler = (ProxyHandler)Preconditions.checkNotNull((Object)proxyHandler);
        this.routingRuleHandler = (RoutingRuleHandler)Preconditions.checkNotNull((Object)routingRuleHandler);
        this.securityHandler = (SecurityHandler)Preconditions.checkNotNull((Object)securityHandler);
        this.timingHandler = (TimingHandler)Preconditions.checkNotNull((Object)timingHandler);
        this.lastDownloadedHandler = (LastDownloadedHandler)Preconditions.checkNotNull((Object)lastDownloadedHandler);
    }

    public void apply(Repository repository) throws Exception {
        repository.attach((Facet)this.securityFacet.get());
        repository.attach((Facet)this.configure((ConfigurableViewFacet)this.viewFacet.get()));
        repository.attach((Facet)this.httpClientFacet.get());
        repository.attach((Facet)this.negativeCacheFacet.get());
        repository.attach((Facet)this.maintenanceFacet.get());
        repository.attach((Facet)this.proxyFacet.get());
        repository.attach((Facet)this.contentFacet.get());
        repository.attach((Facet)this.searchFacet.get());
        repository.attach((Facet)this.purgeUnusedFacet.get());
        repository.attach((Facet)this.cacheInvalidatorFacet.get());
        repository.attach((Facet)this.browseFacet.get());
    }

    static Matcher buildTokenMatcherForPatternAndAssetKind(String pattern, AssetKind assetKind, String ... actions) {
        return LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(actions), new TokenMatcher(pattern), context -> {
            context.getAttributes().set(AssetKind.class, (Object)assetKind);
            return true;
        }});
    }

    private ViewFacet configure(ConfigurableViewFacet facet) {
        Router.Builder builder = new Router.Builder();
        this.addBrowseUnsupportedRoute((RouterBuilder)builder);
        P2ProxyRecipe.createMatchers("/{site:[0-9a-f]{64\\}}").forEach(this.createRoute(builder));
        P2ProxyRecipe.createMatchers("").forEach(this.createRoute(builder));
        builder.defaultHandlers(new Handler[]{HttpHandlers.notFound()});
        facet.configure(builder.create());
        return facet;
    }

    private Consumer<Matcher> createRoute(Router.Builder builder) {
        return matcher -> {
            Router.Builder builder2 = builder.route(new Route.Builder().matcher(matcher).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((org.sonatype.nexus.repository.recipe.Handler)this.routingRuleHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.negativeCacheHandler).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.contentHeadersHandler).handler((Handler)this.lastDownloadedHandler).handler((Handler)this.proxyHandler).create());
        };
    }

    private static List<Matcher> createMatchers(String prefix) {
        String path = "{name:.*}_{version:\\\\d+\\\\.\\\\d+\\\\.\\\\d+(\\\\.[A-Za-z0-9_-]+)?}";
        return Arrays.asList(P2ProxyRecipe.buildTokenMatcherForPatternAndAssetKind(String.valueOf(prefix) + "/p2.index", AssetKind.P2_INDEX, "GET", "HEAD"), P2ProxyRecipe.buildTokenMatcherForPatternAndAssetKind(String.valueOf(prefix) + "/compositeContent.jar", AssetKind.COMPOSITE_CONTENT, "GET", "HEAD"), P2ProxyRecipe.buildTokenMatcherForPatternAndAssetKind(String.valueOf(prefix) + "/compositeContent.xml", AssetKind.COMPOSITE_CONTENT, "GET", "HEAD"), P2ProxyRecipe.buildTokenMatcherForPatternAndAssetKind(String.valueOf(prefix) + "/content.jar", AssetKind.CONTENT_METADATA, "GET", "HEAD"), P2ProxyRecipe.buildTokenMatcherForPatternAndAssetKind(String.valueOf(prefix) + "/content.xml.xz", AssetKind.CONTENT_METADATA, "GET", "HEAD"), P2ProxyRecipe.buildTokenMatcherForPatternAndAssetKind(String.valueOf(prefix) + "/content.xml", AssetKind.CONTENT_METADATA, "GET", "HEAD"), P2ProxyRecipe.buildTokenMatcherForPatternAndAssetKind(String.valueOf(prefix) + "/compositeArtifacts.jar", AssetKind.COMPOSITE_ARTIFACTS, "GET", "HEAD"), P2ProxyRecipe.buildTokenMatcherForPatternAndAssetKind(String.valueOf(prefix) + "/compositeArtifacts.xml", AssetKind.COMPOSITE_ARTIFACTS, "GET", "HEAD"), P2ProxyRecipe.buildTokenMatcherForPatternAndAssetKind(String.valueOf(prefix) + "/artifacts.jar", AssetKind.ARTIFACTS_METADATA, "GET", "HEAD"), P2ProxyRecipe.buildTokenMatcherForPatternAndAssetKind(String.valueOf(prefix) + "/artifacts.xml.xz", AssetKind.ARTIFACTS_METADATA, "GET", "HEAD"), P2ProxyRecipe.buildTokenMatcherForPatternAndAssetKind(String.valueOf(prefix) + "/artifacts.xml", AssetKind.ARTIFACTS_METADATA, "GET", "HEAD"), P2ProxyRecipe.buildTokenMatcherForPatternAndAssetKind(String.valueOf(prefix) + "/{dir:features|plugins}/" + path + ".{extension:.*}", AssetKind.BUNDLE, "GET", "HEAD"), P2ProxyRecipe.buildTokenMatcherForPatternAndAssetKind(String.valueOf(prefix) + "/{dir:binary}/" + path, AssetKind.BINARY_BUNDLE, "GET", "HEAD"));
    }
}

