/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.datastore.internal.proxy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.sonatype.nexus.repository.p2.AssetKind;
import com.sonatype.nexus.repository.p2.datastore.P2ContentFacet;
import com.sonatype.nexus.repository.p2.internal.metadata.CompositeRepositoryRewriter;
import com.sonatype.nexus.repository.p2.internal.metadata.RemoveMirrorTransformer;
import com.sonatype.nexus.repository.p2.internal.metadata.UriToSiteHashUtil;
import com.sonatype.nexus.repository.p2.internal.metadata.XmlTransformer;
import com.sonatype.nexus.repository.p2.internal.proxy.StreamCopier;
import com.sonatype.nexus.repository.p2.util.P2PathUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.facet.ContentProxyFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.mime.ContentValidator;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;

@Named
public class P2ProxyFacet
extends ContentProxyFacetSupport {
    public static final String REMOTE_URL = "remote_url";
    public static final String REMOTE_HASH = "remote_site_hash";
    public static final String MIRRORS_URL = "mirrors_url";
    public static final String CHILD_URLS = "child_urls";
    private final ContentValidator contentValidator;

    @Inject
    public P2ProxyFacet(ContentValidator contentValidator) {
        this.contentValidator = (ContentValidator)Preconditions.checkNotNull((Object)contentValidator);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        super.doValidate(configuration);
    }

    @Nullable
    protected Content getCachedContent(Context context) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case P2_INDEX: 
            case ARTIFACTS_METADATA: 
            case CONTENT_METADATA: 
            case COMPOSITE_ARTIFACTS: 
            case COMPOSITE_CONTENT: 
            case BUNDLE: 
            case BINARY_BUNDLE: {
                return this.content().get(context.getRequest().getPath()).orElse(null);
            }
        }
        throw new IllegalStateException();
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        String remoteUrl = (String)context.getAttributes().require(REMOTE_URL, String.class);
        TokenMatcher.State matcherState = P2PathUtils.matcherState(context);
        String path = context.getRequest().getPath();
        switch (assetKind) {
            case COMPOSITE_ARTIFACTS: 
            case COMPOSITE_CONTENT: {
                return this.storeCompositeMetadata(path, content, assetKind, matcherState, remoteUrl);
            }
            case P2_INDEX: {
                return this.content().putP2Index(path, (Payload)content, Collections.singletonMap(REMOTE_URL, remoteUrl));
            }
            case CONTENT_METADATA: {
                return this.content().putContentMetadata(path, (Payload)content, Collections.singletonMap(REMOTE_URL, remoteUrl));
            }
            case ARTIFACTS_METADATA: {
                return this.storeArtifactsMetadata(path, content, assetKind, matcherState, remoteUrl);
            }
            case BUNDLE: {
                return this.content().putBundle(P2PathUtils.toP2Attributes(path, matcherState), (Payload)content);
            }
            case BINARY_BUNDLE: {
                return this.content().putBinary(P2PathUtils.toP2AttributesBinary(path, matcherState), (Payload)content);
            }
        }
        throw new IllegalStateException();
    }

    @Nullable
    protected Content fetch(Context context, Content stale) throws IOException {
        String url = this.getUrl(context);
        if (url == null) {
            return null;
        }
        return this.fetch(url, context, stale);
    }

    protected String getUrl(@Nonnull Context context) {
        String remoteUrl;
        TokenMatcher.State matcherState = P2PathUtils.matcherState(context);
        String site = (String)matcherState.getTokens().get("site");
        if (site == null) {
            String repositoryUrl = this.getRemoteUrl().toString();
            remoteUrl = URI.create(repositoryUrl.endsWith("/") ? repositoryUrl : String.valueOf(repositoryUrl) + '/').resolve(context.getRequest().getPath().substring(1)).toString();
        } else {
            String path = context.getRequest().getPath().substring(2 + site.length());
            Optional<URI> baseUri = this.findRepositoryUrl(site);
            remoteUrl = baseUri.map(b -> b.resolve(path)).map(Object::toString).orElse(null);
        }
        context.getAttributes().backing().put(REMOTE_URL, remoteUrl);
        return remoteUrl;
    }

    private Optional<URI> findRepositoryUrl(String site) {
        Iterable assets = Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)this.content().assets().byFilter("kind = #{filterParams.artifacts} OR kind = #{filterParams.content}", (Map)ImmutableMap.of((Object)"artifacts", (Object)((Object)AssetKind.COMPOSITE_ARTIFACTS), (Object)"content", (Object)((Object)AssetKind.COMPOSITE_CONTENT)))).browse(arg_0, arg_1));
        for (FluentAsset asset : assets) {
            List<String> urls = this.extractUris(asset);
            for (String url : urls) {
                if (!UriToSiteHashUtil.map(url).equals(site)) continue;
                return Optional.of(URI.create(url));
            }
        }
        this.log.debug("Unknown remote site: {}", (Object)site);
        return Optional.empty();
    }

    private List<String> extractUris(FluentAsset asset) {
        return (List)asset.attributes("p2").get(CHILD_URLS, (TypeToken)new TypeToken<List<String>>(){});
    }

    private Content storeCompositeMetadata(String assetPath, Content content, AssetKind assetKind, TokenMatcher.State matcherState, String remoteUrl) throws IOException {
        boolean isCompositeArtifacts = AssetKind.COMPOSITE_ARTIFACTS == assetKind;
        String site = this.getSiteHash(matcherState);
        String filename = isCompositeArtifacts ? "compositeArtifacts.xml" : "compositeContent.xml";
        URI baseUri = URI.create(remoteUrl);
        CompositeRepositoryRewriter rewriter = new CompositeRepositoryRewriter(baseUri, site == null);
        Throwable throwable = null;
        Object var12_13 = null;
        try (Payload payload = this.rewriteMetadata(assetPath, content, filename, rewriter);){
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(CHILD_URLS, rewriter.getUrls());
            attributes.put(REMOTE_HASH, site);
            attributes.put(REMOTE_URL, remoteUrl);
            Content streamContent = P2ProxyFacet.toContent(payload, content);
            Content content2 = isCompositeArtifacts ? this.content().putCompositeArtifactsMetadata(assetPath, (Payload)streamContent, attributes) : this.content().putCompositeContentMetadata(assetPath, (Payload)streamContent, attributes);
            return content2;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content storeArtifactsMetadata(String assetPath, Content content, AssetKind assetKind, TokenMatcher.State matcherState, String remoteUrl) throws IOException {
        RemoveMirrorTransformer removeMirrorTransformer = new RemoveMirrorTransformer();
        Throwable throwable = null;
        Object var8_9 = null;
        try (Payload payload = this.rewriteMetadata(assetPath, content, "artifacts.xml", removeMirrorTransformer);){
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(REMOTE_HASH, this.getSiteHash(matcherState));
            attributes.put(REMOTE_URL, remoteUrl);
            removeMirrorTransformer.getMirrorsUrl().ifPresent(mirrorsUrl -> {
                String string = attributes.put(MIRRORS_URL, mirrorsUrl);
            });
            return this.content().putArtifactsMetadata(assetPath, (Payload)P2ProxyFacet.toContent(payload, content), attributes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Payload rewriteMetadata(String assetPath, Content content, String internalFilename, XmlTransformer transformer) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var7_8 = null;
        try (InputStream in = content.openInputStream();){
            IOUtils.copy((InputStream)in, (OutputStream)buffer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(buffer.toByteArray());
        buffer.reset();
        String mimeType = this.contentValidator.determineContentType(false, () -> in, null, assetPath, content.getContentType());
        in.reset();
        StreamCopier.copierFor(mimeType, internalFilename, in, buffer).process(transformer);
        return new StreamPayload(() -> new ByteArrayInputStream(buffer.toByteArray()), (long)buffer.size(), mimeType);
    }

    private String getSiteHash(TokenMatcher.State matcherState) {
        String site = (String)matcherState.getTokens().get("site");
        if (site == null) {
            return null;
        }
        return UriToSiteHashUtil.map(this.getRemoteUrl());
    }

    private P2ContentFacet content() {
        return (P2ContentFacet)this.getRepository().facet(P2ContentFacet.class);
    }

    private static Content toContent(Payload payload, Content originalContent) {
        Content streamContent = new Content(payload);
        streamContent.getAttributes().backing().putAll(originalContent.getAttributes().backing());
        return streamContent;
    }
}

