/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.datastore.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.p2.AssetKind;
import com.sonatype.nexus.repository.p2.datastore.P2ContentFacet;
import com.sonatype.nexus.repository.p2.metadata.P2Attributes;
import com.sonatype.nexus.repository.p2.util.P2PathUtils;
import com.sonatype.nexus.repository.p2.util.P2TempBlobUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="p2")
public class P2ContentFacetImpl
extends ContentFacetSupport
implements P2ContentFacet {
    private final P2TempBlobUtils p2TempBlobUtils;

    @Inject
    public P2ContentFacetImpl(@Named(value="p2") @Named(value="p2") FormatStoreManager formatStoreManager, P2TempBlobUtils p2TempBlobUtils) {
        super(formatStoreManager);
        this.p2TempBlobUtils = (P2TempBlobUtils)((Object)Preconditions.checkNotNull((Object)((Object)p2TempBlobUtils)));
    }

    @Override
    public boolean delete(String path) throws IOException {
        return this.assets().path(path).find().map(FluentAsset::delete).orElse(false);
    }

    @Override
    public Optional<Content> get(String path) throws IOException {
        return this.assets().path(path).find().map(FluentAsset::download);
    }

    @Override
    public Content putArtifactsMetadata(String path, Payload payload, Map<String, Object> attributes) throws IOException {
        return this.putMetadata(path, payload, attributes, AssetKind.ARTIFACTS_METADATA);
    }

    @Override
    public Content putBinary(P2Attributes p2Attributes, Payload payload) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob blob = this.blobs().ingest(payload, (Iterable)HASH_ALGORITHMS);){
            return this.putComponent(p2Attributes, blob, payload, AssetKind.BINARY_BUNDLE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putBundle(P2Attributes p2Attributes, Payload payload) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob blob = this.blobs().ingest(payload, (Iterable)HASH_ALGORITHMS);){
            P2Attributes mergedP2Attributes = P2Attributes.builder().merge(P2PathUtils.getAttributesFromBlob(this.p2TempBlobUtils, (InputStreamSupplier)blob, p2Attributes.getPath()), p2Attributes).build();
            return this.putComponent(mergedP2Attributes, blob, payload, AssetKind.BUNDLE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putCompositeArtifactsMetadata(String path, Payload payload, Map<String, Object> attributes) throws IOException {
        return this.putMetadata(path, payload, attributes, AssetKind.COMPOSITE_ARTIFACTS);
    }

    @Override
    public Content putCompositeContentMetadata(String path, Payload payload, Map<String, Object> attributes) throws IOException {
        return this.putMetadata(path, payload, attributes, AssetKind.COMPOSITE_CONTENT);
    }

    @Override
    public Content putContentMetadata(String path, Payload payload, Map<String, Object> attributes) throws IOException {
        return this.putMetadata(path, payload, attributes, AssetKind.CONTENT_METADATA);
    }

    @Override
    public Content putP2Index(String path, Payload payload, Map<String, Object> attributes) {
        return this.putMetadata(path, payload, attributes, AssetKind.P2_INDEX);
    }

    private Content putComponent(P2Attributes attributes, TempBlob blob, Payload payload, AssetKind assetKind) {
        Component component = this.createComponent(attributes, assetKind);
        Map<String, Object> assetAttributes = Collections.emptyMap();
        String pluginName = attributes.getPluginName();
        if (pluginName != null) {
            assetAttributes = Collections.singletonMap("pluginName", pluginName);
        }
        return this.createAsset(component, attributes.getPath(), assetAttributes, assetKind, blob, payload).download();
    }

    private Content putMetadata(String path, Payload payload, Map<String, Object> attributes, AssetKind kind) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob blob = this.blobs().ingest(payload, (Iterable)HASH_ALGORITHMS);){
            return this.createAsset(null, path, attributes, kind, blob, payload).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private FluentAsset createAsset(@Nullable Component component, String path, Map<String, Object> attributes, AssetKind kind, TempBlob blob, Payload payload) {
        FluentAssetBuilder builder = this.assets().path(path).kind(kind.name()).attributes("p2", attributes).blob(blob);
        if (component != null) {
            builder.component(component);
        }
        return builder.save().markAsCached(payload);
    }

    private Component createComponent(P2Attributes attributes, AssetKind assetKind) {
        return this.components().name(attributes.getComponentName()).version(attributes.getComponentVersion()).normalizedVersion(this.versionNormalizerService().getNormalizedVersionByFormat(attributes.getComponentVersion(), this.repository().getFormat())).kind(assetKind.name()).attributes("p2", (Object)attributes).getOrCreate();
    }
}

