/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.p2.internal.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.restore.p2.internal.datastore.P2RestoreBlobData;
import com.sonatype.nexus.repository.p2.AssetKind;
import com.sonatype.nexus.repository.p2.datastore.P2ContentFacet;
import com.sonatype.nexus.repository.p2.metadata.P2Attributes;
import com.sonatype.nexus.repository.p2.util.P2PathUtils;
import com.sonatype.nexus.repository.p2.util.P2TempBlobUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheControllerHolder;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;

@Named(value="p2")
@Singleton
public class P2RestoreBlobStrategy
extends BaseRestoreBlobStrategy<P2RestoreBlobData> {
    private final RepositoryManager repositoryManager;
    private final P2TempBlobUtils p2TempBlobUtils;

    @Inject
    public P2RestoreBlobStrategy(DryRunPrefix dryRunPrefix, RepositoryManager repositoryManager, P2TempBlobUtils p2TempBlobUtils) {
        super(dryRunPrefix);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.p2TempBlobUtils = (P2TempBlobUtils)((Object)Preconditions.checkNotNull((Object)((Object)p2TempBlobUtils)));
    }

    protected P2RestoreBlobData createRestoreData(Properties props, Blob blob, BlobStore blobStore) {
        Optional<P2Attributes> p2Attributes = this.getRepository(blob).flatMap(repository -> repository.optionalFacet(P2ContentFacet.class)).map(p2ContentFacet -> this.getAttributes(blob));
        return new P2RestoreBlobData(blob, props, blobStore, this.repositoryManager, p2Attributes);
    }

    protected boolean canAttemptRestore(@Nonnull P2RestoreBlobData data) {
        if (!data.getRepository().optionalFacet(P2ContentFacet.class).isPresent()) {
            this.log.warn("Skipping as P2 Content Facet not found on repository: {}", (Object)data.getRepository().getName());
            return false;
        }
        if (!data.getP2Attributes().isPresent()) {
            this.log.warn("Skipping as P2 attributes were not found: {}", (Object)data.getBlobName());
            return false;
        }
        return true;
    }

    protected void createAssetFromBlob(Blob assetBlob, P2RestoreBlobData data) throws IOException {
        P2ContentFacet contentFacet = (P2ContentFacet)data.getRepository().facet(P2ContentFacet.class);
        String path = this.getAssetPath(data);
        this.restore(contentFacet, path, assetBlob);
    }

    private void restore(P2ContentFacet contentFacet, String path, Blob blob) throws IOException {
        AssetKind assetKind = P2PathUtils.getAssetKind(path);
        switch (assetKind) {
            case COMPOSITE_ARTIFACTS: {
                this.log.info("Unable to restore references to remote URLs for {} from blob", (Object)path);
                contentFacet.putCompositeArtifactsMetadata(path, (Payload)new DetachedBlobPayload(blob), Collections.emptyMap());
                break;
            }
            case COMPOSITE_CONTENT: {
                this.log.info("Unable to restore references to remote URLs for {} from blob", (Object)path);
                contentFacet.putCompositeContentMetadata(path, (Payload)new DetachedBlobPayload(blob), Collections.emptyMap());
                break;
            }
            case P2_INDEX: {
                this.log.info("Unable to restore references to remote URLs for {} from blob", (Object)path);
                contentFacet.putP2Index(path, (Payload)new DetachedBlobPayload(blob), Collections.emptyMap());
                break;
            }
            case CONTENT_METADATA: {
                this.log.info("Unable to restore references to remote URLs for {} from blob", (Object)path);
                contentFacet.putContentMetadata(path, (Payload)new DetachedBlobPayload(blob), Collections.emptyMap());
                break;
            }
            case ARTIFACTS_METADATA: {
                this.log.info("Unable to restore references to remote URLs for {} from blob", (Object)path);
                contentFacet.putArtifactsMetadata(path, (Payload)new DetachedBlobPayload(blob), Collections.emptyMap());
                break;
            }
            case BUNDLE: {
                P2Attributes p2Attributes = P2PathUtils.getAttributesFromBlob(this.p2TempBlobUtils, () -> ((Blob)blob).getInputStream(), path);
                contentFacet.putBinary(p2Attributes, (Payload)new DetachedBlobPayload(blob));
                break;
            }
            case BINARY_BUNDLE: {
                P2Attributes p2Attributes = P2PathUtils.getAttributesFromBlob(this.p2TempBlobUtils, () -> ((Blob)blob).getInputStream(), path);
                contentFacet.putBundle(p2Attributes, (Payload)new DetachedBlobPayload(blob));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected String getAssetPath(@Nonnull P2RestoreBlobData data) {
        return data.getP2Attributes().map(P2Attributes::getPath).orElseThrow(() -> new IllegalStateException("Restore data has no attributes"));
    }

    private Optional<Repository> getRepository(Blob blob) {
        return Optional.ofNullable(blob.getHeaders()).map(headers -> (String)headers.get("Bucket.repo-name")).map(arg_0 -> ((RepositoryManager)this.repositoryManager).get(arg_0));
    }

    private P2Attributes getAttributes(Blob blob) {
        String blobName = (String)blob.getHeaders().get("BlobStore.blob-name");
        if (!blobName.startsWith("/")) {
            blobName = "/" + blobName;
        }
        try {
            return P2PathUtils.getAttributesFromBlob(this.p2TempBlobUtils, () -> ((Blob)blob).getInputStream(), blobName);
        }
        catch (IOException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.info("Failed to get package attributes for {}:{}, falling back to minimal attributes", new Object[]{blobName, blob.getId(), ex});
            } else {
                this.log.info("Failed to get package attributes for {}:{}, falling back to minimal attributes", (Object)blobName, (Object)blob.getId());
            }
            return P2PathUtils.getMinimalAttributes(blobName);
        }
    }

    protected boolean isComponentRequired(P2RestoreBlobData data) {
        return CacheControllerHolder.CONTENT.equals((Object)P2PathUtils.getAssetKind(this.getAssetPath(data)).getCacheType());
    }

    public void after(boolean updateAssets, Repository repository) {
    }
}

