/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.payloads;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;

public class TempBlob
implements Closeable,
InputStreamSupplier {
    private static final Logger log = LoggerFactory.getLogger(TempBlob.class);
    protected final Blob blob;
    protected final Map<HashAlgorithm, HashCode> hashes;
    protected final boolean hashesVerified;
    protected final BlobStore blobStore;
    protected boolean deleted = false;

    public TempBlob(Blob blob, Map<HashAlgorithm, HashCode> hashes, boolean hashesVerified, BlobStore blobStore) {
        this.blob = (Blob)Preconditions.checkNotNull((Object)blob);
        this.hashes = (Map)Preconditions.checkNotNull(hashes);
        this.hashesVerified = hashesVerified;
        this.blobStore = (BlobStore)Preconditions.checkNotNull((Object)blobStore);
    }

    public Blob getBlob() {
        return this.blob;
    }

    public BlobRef getBlobRef(String node) {
        return new BlobRef(node, this.blobStore.getBlobStoreConfiguration().getName(), this.getBlob().getId().asUniqueString());
    }

    public Map<HashAlgorithm, HashCode> getHashes() {
        return this.hashes;
    }

    public boolean getHashesVerified() {
        return this.hashesVerified;
    }

    @Override
    public void close() {
        if (this.deleted) {
            return;
        }
        try {
            this.blobStore.deleteIfTemp(this.blob.getId());
            this.deleted = true;
        }
        catch (BlobStoreException e) {
            log.debug("Unable to delete blob {} in blob store {}", new Object[]{this.blob.getId(), this.blobStore.getBlobStoreConfiguration().getName(), e});
        }
    }

    public InputStream get() {
        return this.blob.getInputStream();
    }
}

