/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.payloads;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.view.Payload;

public class StringPayload
implements Payload {
    private final byte[] contentBytes;
    private final Charset charset;
    private final String contentType;

    public StringPayload(String content, Charset charset, @Nullable String contentType) {
        this.contentBytes = ((String)Preconditions.checkNotNull((Object)content)).getBytes(charset);
        this.charset = (Charset)Preconditions.checkNotNull((Object)charset);
        this.contentType = contentType;
    }

    public StringPayload(String content, @Nullable String contentType) {
        this(content, StandardCharsets.UTF_8, contentType);
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new ByteArrayInputStream(this.contentBytes);
    }

    @Override
    public long getSize() {
        return this.contentBytes.length;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "size=" + this.contentBytes.length + ", charset=" + this.charset + ", contentType='" + this.contentType + '\'' + '}';
    }
}

