/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.payloads;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.view.Payload;

public class StreamPayload
implements Payload {
    private final InputStreamSupplier stream;
    private final long size;
    private final String contentType;

    public StreamPayload(InputStreamSupplier stream, long size, @Nullable String contentType) {
        this.stream = (InputStreamSupplier)Preconditions.checkNotNull((Object)stream);
        this.size = size;
        this.contentType = contentType;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.stream.get();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "stream=" + this.stream + ", size=" + this.size + ", contentType='" + this.contentType + '\'' + '}';
    }

    public static interface InputStreamFunction<T> {
        @Nonnull
        public InputStream apply(T var1) throws IOException;
    }
}

