/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.payloads;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.view.Payload;

public class PathPayload
implements Payload {
    private final Path path;
    private final String contentType;

    public PathPayload(Path path, @Nullable String contentType) {
        this.path = (Path)Preconditions.checkNotNull((Object)path);
        this.contentType = contentType;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new BufferedInputStream(Files.newInputStream(this.path, StandardOpenOption.READ));
    }

    @Override
    public long getSize() {
        try {
            return Files.size(this.path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }
}

