/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.matchers.token;

import com.google.common.base.Preconditions;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonatype.nexus.repository.view.matchers.token.LiteralToken;
import org.sonatype.nexus.repository.view.matchers.token.Token;
import org.sonatype.nexus.repository.view.matchers.token.VariableToken;

public class PatternParser {
    public static final String DEFAULT_VARIABLE_REGEXP = "[^/]+";
    private static final List<Character> ESCAPE_CHARS = Arrays.asList(Character.valueOf('\\'));
    private static final List<Character> VARNAME_DISALLOWED_CHARS = Arrays.asList(Character.valueOf(' '), Character.valueOf('}'));
    private static final List<Character> VARIABLE_NAME_TERMINATORS = Arrays.asList(Character.valueOf(':'), Character.valueOf('}'));
    private static final List<Character> END_OF_LITERAL = Arrays.asList(Character.valueOf('{'));
    private static final List<Character> END_OF_VARIABLE_DECLARATION = Arrays.asList(Character.valueOf('}'));
    private List<Token> tokens = new ArrayList<Token>();
    private static final List<Character> NONE = Collections.emptyList();

    public PatternParser(String tokenPattern) {
        Preconditions.checkNotNull((Object)tokenPattern);
        this.parseTemplate(new StringCharacterIterator(tokenPattern));
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    private void parseTemplate(CharacterIterator iterator) {
        block4: while (true) {
            char ch = iterator.current();
            switch (ch) {
                case '\uffff': {
                    return;
                }
                case '{': {
                    this.parseVariable(iterator);
                    continue block4;
                }
            }
            this.parseLiteral(iterator);
        }
    }

    private void parseVariable(CharacterIterator iterator) {
        iterator.next();
        String varName = PatternParser.readFragment(iterator, VARIABLE_NAME_TERMINATORS, ESCAPE_CHARS, VARNAME_DISALLOWED_CHARS);
        if (iterator.current() == ':') {
            iterator.next();
            String regexp = PatternParser.readFragment(iterator, END_OF_VARIABLE_DECLARATION, ESCAPE_CHARS, NONE);
            this.tokens.add(new VariableToken(varName, regexp));
        } else {
            this.tokens.add(new VariableToken(varName, DEFAULT_VARIABLE_REGEXP));
        }
        Preconditions.checkArgument((iterator.current() == '}' ? 1 : 0) != 0, (String)"Variable does not end with '}' at position %s", (int)iterator.getIndex());
        iterator.next();
    }

    private void parseLiteral(CharacterIterator iterator) {
        String literal = PatternParser.readFragment(iterator, END_OF_LITERAL, ESCAPE_CHARS, NONE);
        this.tokens.add(new LiteralToken(literal));
    }

    static String readFragment(CharacterIterator iterator, List<Character> stopChars, List<Character> escapeChars, List<Character> disallowed) {
        StringBuilder b = new StringBuilder();
        boolean escaping = false;
        while (true) {
            char ch;
            if ((ch = iterator.current()) == '\uffff') {
                Preconditions.checkArgument((!escaping ? 1 : 0) != 0, (Object)String.format("Unexpected end after escape character '%s' at position %s.", Character.valueOf(ch), iterator.getIndex()));
                Preconditions.checkArgument((b.length() >= 1 ? 1 : 0) != 0, (Object)String.format("Zero-length fragment at position %s.", iterator.getIndex()));
                return b.toString();
            }
            if (escaping) {
                PatternParser.checkAllowed(iterator, disallowed);
                b.append(ch);
                escaping = false;
            } else if (escapeChars.contains(Character.valueOf(ch))) {
                escaping = true;
            } else {
                if (stopChars.contains(Character.valueOf(ch))) {
                    return b.toString();
                }
                PatternParser.checkAllowed(iterator, disallowed);
                b.append(ch);
            }
            iterator.next();
        }
    }

    private static void checkAllowed(CharacterIterator iterator, List<Character> disallowed) {
        Preconditions.checkArgument((!disallowed.contains(Character.valueOf(iterator.current())) ? 1 : 0) != 0, (String)"Disallowed character %s at position %s", (char)iterator.current(), (int)iterator.getIndex());
    }
}

