/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.handlers;

import com.google.common.base.Stopwatch;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.AttributeKey;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class TimingHandler
extends ComponentSupport
implements Handler {
    public static final String ELAPSED_KEY = AttributeKey.get(TimingHandler.class, (String)"elapsed");
    private final Handler meteringHandler;

    @Inject
    public TimingHandler(@Named(value="nexus.analytics.meteringHandler") @Nullable @Named(value="nexus.analytics.meteringHandler") @Nullable Handler meteringHandler) {
        this.meteringHandler = meteringHandler;
    }

    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Stopwatch watch = Stopwatch.createStarted();
        try {
            if (this.meteringHandler != null) {
                context.insertHandler(this.meteringHandler);
            }
            Response response = context.proceed();
            return response;
        }
        finally {
            String elapsed = watch.toString();
            context.getAttributes().set(ELAPSED_KEY, (Object)elapsed);
            this.log.trace("Timing: {}", (Object)elapsed);
        }
    }
}

