/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.handlers;

import javax.annotation.Nonnull;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FrozenException;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

public class ExceptionHandler
extends ComponentSupport
implements Handler {
    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        try {
            return context.proceed();
        }
        catch (IllegalOperationException e) {
            this.log.warn("Illegal operation: {} {}: {}", new Object[]{context.getRequest().getAction(), context.getRequest().getPath(), e.toString()});
            return HttpResponses.badRequest(e.getMessage());
        }
        catch (InvalidContentException e) {
            this.log.warn("Invalid content: {} {}: {}", new Object[]{context.getRequest().getAction(), context.getRequest().getPath(), e.toString()});
            if ("PUT".equals(context.getRequest().getAction())) {
                return HttpResponses.badRequest(e.getMessage());
            }
            return HttpResponses.notFound(e.getMessage());
        }
        catch (FrozenException e) {
            return this.readOnly(context, (Exception)((Object)e));
        }
        catch (Exception e) {
            if (e.getCause() instanceof FrozenException) {
                return this.readOnly(context, e);
            }
            String exceptionName = e.getClass().getSimpleName();
            if (exceptionName.contains("OModificationOperationProhibitedException") || exceptionName.contains("OWriteOperationNotPermittedException")) {
                return this.readOnly(context, e);
            }
            throw e;
        }
    }

    private Response readOnly(Context context, Exception e) {
        this.log.warn("Nexus Repository Manager is in read-only mode: {} {}: {}", new Object[]{context.getRequest().getAction(), context.getRequest().getPath(), e.toString()});
        return HttpResponses.serviceUnavailable("Nexus Repository Manager is in read-only mode");
    }
}

