/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.ViewUtils;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

public class Context {
    private static final Logger log = LoggerFactory.getLogger(Context.class);
    private final AttributesMap attributes = new AttributesMap();
    private final Repository repository;
    private final Request request;
    private ListIterator<Handler> handlers;

    public Context(Repository repository, Request request) {
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
        this.request = (Request)Preconditions.checkNotNull((Object)request);
    }

    public AttributesMap getAttributes() {
        return this.attributes;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Request getRequest() {
        return this.request;
    }

    @Nonnull
    public Response proceed() throws Exception {
        Preconditions.checkState((this.handlers != null ? 1 : 0) != 0, (Object)"Context not started");
        Preconditions.checkState((boolean)this.handlers.hasNext(), (Object)"End of handler chain");
        Handler handler = this.handlers.next();
        try {
            log.debug("Proceeding: {}", (Object)handler);
            Response response = handler.handle(this);
            return response;
        }
        finally {
            if (this.handlers.hasPrevious()) {
                this.handlers.previous();
            }
        }
    }

    public void insertHandler(Handler handler) {
        Preconditions.checkNotNull((Object)handler);
        this.handlers.add(handler);
        this.handlers.previous();
    }

    public Context replayable() throws IOException {
        Payload payload = (Payload)Preconditions.checkNotNull((Object)this.request.getPayload());
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = payload.openInputStream();){
            byte[] content = IOUtils.toByteArray((InputStream)in);
            Context replayableContext = new Context(this.repository, new Request.Builder().attributes(this.request.getAttributes()).headers(this.request.getHeaders()).action(this.request.getAction()).path(this.request.getPath()).parameters(this.request.getParameters()).payload(new BytesPayload(content, payload.getContentType())).build());
            ViewUtils.copyLocalContextAttributes(this, replayableContext);
            return replayableContext;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Context copy(UnaryOperator<AttributesMap> attributesCustomizer, UnaryOperator<Request.Builder> requestCustomizer) throws IOException {
        Request.Builder builder = new Request.Builder().attributes(this.request.getAttributes()).headers(this.request.getHeaders()).action(this.request.getAction()).path(this.request.getPath()).parameters(this.request.getParameters());
        if (this.request.getPayload() != null) {
            Payload payload = this.request.getPayload();
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream in = payload.openInputStream();){
                byte[] content = IOUtils.toByteArray((InputStream)in);
                builder.payload(new BytesPayload(content, payload.getContentType()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        Request newRequest = ((Request.Builder)requestCustomizer.apply(builder)).build();
        Context contextCopy = new Context(this.repository, newRequest);
        AttributesMap newAttributes = (AttributesMap)attributesCustomizer.apply(this.attributes);
        contextCopy.getAttributes().clear();
        newAttributes.forEach(e -> {
            Object object = contextCopy.getAttributes().set((String)e.getKey(), e.getValue());
        });
        return contextCopy;
    }

    @Nonnull
    Response start(Route route) throws Exception {
        Preconditions.checkNotNull((Object)route);
        Preconditions.checkState((this.handlers == null ? 1 : 0) != 0, (Object)"Already started");
        log.debug("Starting: {}", (Object)route);
        this.handlers = new ArrayList<Handler>(route.getHandlers()).listIterator();
        return this.proceed();
    }
}

