/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Range;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.client.utils.DateUtils;
import org.joda.time.DateTime;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.http.PartialPayload;
import org.sonatype.nexus.repository.http.RangeParser;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;

@Named
@Singleton
public class PartialFetchHandler
implements Handler {
    private final RangeParser rangeParser;

    @Inject
    public PartialFetchHandler(RangeParser rangeParser) {
        this.rangeParser = (RangeParser)((Object)Preconditions.checkNotNull((Object)((Object)rangeParser)));
    }

    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Response response = context.proceed();
        if (!"GET".equals(context.getRequest().getAction())) {
            return response;
        }
        if (response.getStatus().getCode() != 200) {
            return response;
        }
        Payload payload = response.getPayload();
        if (payload == null) {
            return response;
        }
        if (payload.getSize() == -1L) {
            return response;
        }
        String rangeHeader = PartialFetchHandler.getHeaderValue(context.getRequest(), "Range");
        if (rangeHeader == null) {
            return response;
        }
        List<Range<Long>> ranges = this.rangeParser.parseRangeSpec(rangeHeader, payload.getSize());
        if (ranges == null) {
            return HttpResponses.rangeNotSatisfiable(payload.getSize());
        }
        if (ranges.isEmpty()) {
            return response;
        }
        if (ranges.size() > 1) {
            return HttpResponses.notImplemented("Multiple ranges not supported.");
        }
        String ifRangeHeader = PartialFetchHandler.getHeaderValue(context.getRequest(), "If-Range");
        if (ifRangeHeader != null && !PartialFetchHandler.ifRangeHeaderMatches(response, ifRangeHeader)) {
            return response;
        }
        Range<Long> requestedRange = ranges.get(0);
        return this.partialResponse(response, payload, requestedRange);
    }

    private Response partialResponse(Response response, Payload payload, Range<Long> requestedRange) {
        Response.Builder builder = new Response.Builder().copy(response).status(Status.success(206));
        PartialPayload partialPayload = new PartialPayload(payload, requestedRange);
        builder.payload(partialPayload);
        builder.header("Content-Range", "bytes " + requestedRange.lowerEndpoint() + "-" + requestedRange.upperEndpoint() + "/" + payload.getSize());
        return builder.build();
    }

    private static boolean ifRangeHeaderMatches(Response response, String ifRangeHeader) {
        if (ifRangeHeader.startsWith("\"")) {
            String responseEtagHeader = PartialFetchHandler.getHeaderValue(response, "ETag");
            return ifRangeHeader.equals(responseEtagHeader);
        }
        DateTime ifRangeHeaderDateTimeValue = PartialFetchHandler.parseDateTime(ifRangeHeader);
        if (ifRangeHeaderDateTimeValue != null) {
            DateTime responseLastModifiedHeader = PartialFetchHandler.parseDateTime(PartialFetchHandler.getHeaderValue(response, "Last-Modified"));
            return ifRangeHeaderDateTimeValue.equals((Object)responseLastModifiedHeader);
        }
        return false;
    }

    private static String getHeaderValue(Request request, String header) {
        return request.getHeaders().get(header);
    }

    private static String getHeaderValue(Response response, String header) {
        return response.getHeaders().get(header);
    }

    private static DateTime parseDateTime(String stringValue) {
        Date date;
        if (!Strings.isNullOrEmpty((String)stringValue) && (date = DateUtils.parseDate((String)stringValue)) != null) {
            return new DateTime(date.getTime());
        }
        return null;
    }
}

