/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.time.DateHelper;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Payload;

public class Content
implements Payload {
    @VisibleForTesting
    public static final String CONTENT = "content";
    public static final String CONTENT_LAST_MODIFIED = "last_modified";
    public static final String CONTENT_ETAG = "etag";
    public static final String CONTENT_HASH_CODES_MAP = "hashCodesMap";
    public static final TypeToken<Map<HashAlgorithm, HashCode>> T_CONTENT_HASH_CODES_MAP = new TypeToken<Map<HashAlgorithm, HashCode>>(){};
    private final Payload payload;
    private final AttributesMap attributes;
    @VisibleForTesting
    public static final String P_LAST_MODIFIED = "last_modified";
    @VisibleForTesting
    public static final String P_ETAG = "etag";

    public Content(Payload payload) {
        this.payload = (Payload)Preconditions.checkNotNull((Object)payload);
        this.attributes = new AttributesMap();
    }

    public Content(Content originalContent, Payload payload) {
        this.payload = (Payload)Preconditions.checkNotNull((Object)payload);
        this.attributes = originalContent.getAttributes();
    }

    protected Content(Payload payload, AttributesMap attributes) {
        this.payload = (Payload)Preconditions.checkNotNull((Object)payload);
        this.attributes = (AttributesMap)Preconditions.checkNotNull((Object)attributes);
    }

    public InputStream openInputStream() throws IOException {
        return this.payload.openInputStream();
    }

    public long getSize() {
        return this.payload.getSize();
    }

    @Nullable
    public String getContentType() {
        return this.payload.getContentType();
    }

    public void close() throws IOException {
        this.payload.close();
    }

    public void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.payload.copy(inputStream, outputStream);
    }

    @Nonnull
    public AttributesMap getAttributes() {
        return this.attributes;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "payload=" + this.payload + ", attributes='" + this.attributes + '\'' + '}';
    }

    public static void extractFromAsset(Asset asset, Iterable<HashAlgorithm> hashAlgorithms, AttributesMap contentAttributes) {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkNotNull(hashAlgorithms);
        NestedAttributesMap assetAttributes = asset.attributes().child(CONTENT);
        DateTime lastModified = DateHelper.toDateTime((Date)((Date)assetAttributes.get("last_modified", Date.class)));
        Map<HashAlgorithm, HashCode> checksums = asset.getChecksums(hashAlgorithms);
        String etag = (String)assetAttributes.get("etag", String.class);
        if (etag == null) {
            etag = Optional.ofNullable(checksums).map(chk -> (HashCode)chk.get(HashAlgorithm.SHA1)).map(HashCode::toString).orElse(null);
        }
        contentAttributes.set(Asset.class, (Object)asset);
        contentAttributes.set("last_modified", (Object)lastModified);
        contentAttributes.set("etag", (Object)etag);
        contentAttributes.set(CONTENT_HASH_CODES_MAP, checksums);
        contentAttributes.set(CacheInfo.class, (Object)CacheInfo.extractFromAsset(asset));
    }

    public static void applyToAsset(Asset asset, AttributesMap contentAttributes) {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkNotNull((Object)contentAttributes);
        NestedAttributesMap assetAttributes = asset.attributes().child(CONTENT);
        assetAttributes.set("last_modified", (Object)DateHelper.toDate((DateTime)((DateTime)contentAttributes.get("last_modified", DateTime.class))));
        assetAttributes.set("etag", contentAttributes.get("etag", String.class));
        CacheInfo cacheInfo = (CacheInfo)contentAttributes.get(CacheInfo.class);
        if (cacheInfo != null) {
            CacheInfo.applyToAsset(asset, cacheInfo);
        }
    }

    @Nullable
    public static Asset findAsset(StorageTx tx, Bucket bucket, Content content) {
        Asset contentAsset = (Asset)content.getAttributes().require(Asset.class);
        if (EntityHelper.hasMetadata((Entity)contentAsset)) {
            return tx.findAsset(EntityHelper.id((Entity)contentAsset), bucket);
        }
        return null;
    }

    @Nonnull
    public static AttributesMap maintainLastModified(Asset asset, @Nullable AttributesMap contentAttributes) {
        AttributesMap ca = contentAttributes;
        if (ca == null) {
            ca = new AttributesMap();
        }
        if (!ca.contains("last_modified")) {
            ca.set("last_modified", (Object)DateTime.now());
        }
        return ca;
    }
}

