/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upload.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUploadException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.importtask.ImportResult;
import org.sonatype.nexus.repository.rest.ComponentUploadExtension;
import org.sonatype.nexus.repository.rest.internal.resources.ComponentUploadUtils;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandler;
import org.sonatype.nexus.repository.upload.UploadManager;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.upload.internal.BlobStoreMultipartForm;
import org.sonatype.nexus.repository.upload.internal.UploadComponentMultipartHelper;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.rest.ValidationErrorsException;

@FeatureFlag(name="nexus.orient.enabled")
@Named(value="default")
@Singleton
public class OrientUploadManagerImpl
extends ComponentSupport
implements UploadManager {
    private List<UploadDefinition> uploadDefinitions;
    private Map<String, UploadHandler> uploadHandlers;
    private UploadComponentMultipartHelper multipartHelper;
    private Set<ComponentUploadExtension> componentUploadExtensions;

    @Inject
    public OrientUploadManagerImpl(Map<String, UploadHandler> uploadHandlers, UploadComponentMultipartHelper multipartHelper, Set<ComponentUploadExtension> componentsUploadExtensions) {
        this.uploadHandlers = (Map)Preconditions.checkNotNull(uploadHandlers);
        this.uploadDefinitions = Collections.unmodifiableList(uploadHandlers.values().stream().map(handler -> handler.getDefinition()).collect(Collectors.toList()));
        this.multipartHelper = (UploadComponentMultipartHelper)Preconditions.checkNotNull((Object)multipartHelper);
        this.componentUploadExtensions = (Set)Preconditions.checkNotNull(componentsUploadExtensions);
    }

    public Collection<UploadDefinition> getAvailableDefinitions() {
        return this.uploadDefinitions;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UploadResponse handle(Repository repository, HttpServletRequest request) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)request);
        if (!repository.getConfiguration().isOnline()) {
            throw new ValidationErrorsException("Repository offline");
        }
        uploadHandler = this.getUploadHandler(repository);
        upload = this.create(repository, request);
        this.logUploadDetails(upload, repository);
        try {
            for (ComponentUploadExtension componentUploadExtension : this.componentUploadExtensions) {
                componentUploadExtension.validate(upload);
            }
            uploadResponse = uploadHandler.handle(repository, uploadHandler.getValidatingComponentUpload(upload).getComponentUpload());
            for (ComponentUploadExtension componentUploadExtension : this.componentUploadExtensions) {
                componentUploadExtension.apply(repository, upload, uploadResponse.getComponentIds());
            }
            var9_8 = uploadResponse;
            return var9_8;
        }
        finally {
            ** for (assetUpload : upload.getAssetUploads())
        }
lbl-1000:
        // 1 sources

        {
            assetUpload.getPayload().close();
            continue;
        }
lbl24:
        // 1 sources

        return var9_8;
    }

    public UploadDefinition getByFormat(String format) {
        Preconditions.checkNotNull((Object)format);
        UploadHandler handler = this.uploadHandlers.get(format);
        return handler != null ? handler.getDefinition() : null;
    }

    public Content handle(ImportFileConfiguration configuration) throws IOException {
        UploadHandler uploadHandler = this.getUploadHandler(configuration.getRepository());
        if (configuration.isHardLinkingEnabled()) {
            return uploadHandler.handle(configuration);
        }
        return uploadHandler.handle(configuration.getRepository(), configuration.getFile(), configuration.getAssetName());
    }

    public void handleAfterImport(ImportResult importResult) throws IOException {
        Repository repository = importResult.getRepository();
        UploadHandler uploadHandler = this.getUploadHandler(repository);
        uploadHandler.handleAfterImport(importResult);
    }

    private ComponentUpload create(Repository repository, HttpServletRequest request) throws IOException {
        try {
            BlobStoreMultipartForm multipartForm = this.multipartHelper.parse(repository, request);
            return ComponentUploadUtils.createComponentUpload((String)repository.getFormat().getValue(), (BlobStoreMultipartForm)multipartForm);
        }
        catch (FileUploadException e) {
            throw new IOException(e);
        }
    }

    private UploadHandler getUploadHandler(Repository repository) {
        if (!(repository.getType() instanceof HostedType)) {
            throw new ValidationErrorsException(String.format("Uploading components to a '%s' type repository is unsupported, must be '%s'", repository.getType().getValue(), "hosted"));
        }
        String repositoryFormat = repository.getFormat().toString();
        UploadHandler uploadHandler = this.uploadHandlers.get(repositoryFormat);
        if (uploadHandler == null) {
            throw new ValidationErrorsException(String.format("Uploading components to '%s' repositories is unsupported", repositoryFormat));
        }
        return uploadHandler;
    }

    private void logUploadDetails(ComponentUpload componentUpload, Repository repository) {
        Map componentFields = componentUpload.getFields();
        List assetUploads = componentUpload.getAssetUploads();
        StringBuilder sb = new StringBuilder();
        sb.append("Uploading component with parameters: ").append("repository").append("=\"").append(repository.getName()).append("\" ").append("format").append("=\"").append(repository.getFormat().getValue()).append("\" ");
        for (Map.Entry entry : componentFields.entrySet()) {
            sb.append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\" ");
        }
        this.log.info(sb.toString());
        for (AssetUpload assetUpload : assetUploads) {
            sb = new StringBuilder();
            sb.append("Asset with parameters: ");
            sb.append("file=\"").append(assetUpload.getPayload().getName()).append("\" ");
            for (Map.Entry entry : assetUpload.getFields().entrySet()) {
                sb.append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\" ");
            }
            this.log.info(sb.toString());
        }
    }
}

