/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.upgrade.Dependencies;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;

@Named
@Singleton
@Upgrades(model="OrientBlobReconciliationLogMigrator", from="1.0", to="1.1")
@Dependencies(value={@DependsOn(model="component", version="1.16", checkpoint=true), @DependsOn(model="config", version="1.9")})
public class OrientBlobReconciliationLogMigrator_1_1
extends DatabaseUpgradeSupport {
    public static final String NAME = "OrientBlobReconciliationLogMigrator";
    public static final String RECONCILIATION_DIRECTORY_NAME = "reconciliation";
    protected static final String BLOBSTORE = "blobstore";
    protected static final String BLOBSTORE_LOG_PATH = "log" + File.separator + "blobstore";
    protected static final String ATTRIBUTES = "attributes";
    private static final String BLOBSTORE_CONFIG_SELECT = "SELECT FROM repository_blobstore WHERE name = '%s'";
    private final ApplicationDirectories applicationDirectories;
    private final Provider<DatabaseInstance> databaseInstance;

    @Inject
    public OrientBlobReconciliationLogMigrator_1_1(ApplicationDirectories applicationDirectories, @Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance) {
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
    }

    public void apply() throws Exception {
        File reconciliationLogsBaseDirectory = this.applicationDirectories.getWorkDirectory(BLOBSTORE_LOG_PATH);
        Optional.ofNullable(reconciliationLogsBaseDirectory).map(File::listFiles).ifPresent(this::copyFiles);
        Optional.ofNullable(reconciliationLogsBaseDirectory).ifPresent(this::deleteDirectory);
    }

    private void deleteDirectory(File reconciliationLogsBaseDirectory) {
        try {
            FileUtils.deleteDirectory((File)reconciliationLogsBaseDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void copyFiles(File[] blobStoreReconciliationLogDirs) {
        this.log.info("Found reconciliation logs for {} blob stores to migrate", (Object)blobStoreReconciliationLogDirs.length);
        File[] fileArray = blobStoreReconciliationLogDirs;
        int n = blobStoreReconciliationLogDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File reconciliationLogDirectory = fileArray[n2];
            String blobStoreName = reconciliationLogDirectory.getName();
            this.getBlobStorePath(blobStoreName).map(this::toAbsoluteBlobStorePath).ifPresent(blobStorePath -> this.copyDirectoryContentsToBlobstore(reconciliationLogDirectory, (Path)blobStorePath));
            ++n2;
        }
    }

    private void copyDirectoryContentsToBlobstore(File sourceDir, Path blobStorePath) {
        try {
            Path destination = blobStorePath.resolve(RECONCILIATION_DIRECTORY_NAME);
            List logFiles = Optional.ofNullable(sourceDir.listFiles()).map(fileArray -> Arrays.asList(fileArray)).orElse(Collections.emptyList());
            this.log.info("Copying reconciliation logs from {} to {}", (Object)sourceDir, (Object)destination);
            FileUtils.copyToDirectory(logFiles, (File)destination.toFile());
            this.log.info("Copied reconciliation logs from {} to {}", (Object)sourceDir, (Object)destination);
            FileUtils.deleteDirectory((File)sourceDir);
        }
        catch (IOException e) {
            this.log.warn("Skipping copy of reconciliation logs contained in {} because of error {}", (Object)sourceDir, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    private Optional<Path> getBlobStorePath(String blobStoreName) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            List results = (List)db.command((OCommandRequest)new OCommandSQL(String.format(BLOBSTORE_CONFIG_SELECT, blobStoreName))).execute(new Object[0]);
            return results.stream().map(doc -> (Map)doc.field(ATTRIBUTES, OType.EMBEDDEDMAP)).map(attr -> (Map)attr.get("file")).filter(Objects::nonNull).map(config -> config.get("path")).filter(Objects::nonNull).map(Object::toString).map(string -> Paths.get(string, new String[0])).findFirst();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Path toAbsoluteBlobStorePath(Path configurationPath) {
        if (configurationPath.isAbsolute()) {
            return configurationPath;
        }
        Path baseDir = this.applicationDirectories.getWorkDirectory("blobs").toPath();
        try {
            Path normalizedBase = baseDir.toRealPath(new LinkOption[0]).normalize();
            return normalizedBase.resolve(configurationPath.normalize());
        }
        catch (IOException iOException) {
            this.log.error("Error converting {} to absolute path.", (Object)baseDir);
            return null;
        }
    }
}

