/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.upgrade.Upgrade;

public class ElasticSearchIndexUpgradeSupport
extends ComponentSupport
implements Upgrade {
    public static final String NEXUS_LSN = "nexus.lsn";
    private File nexusLsnFile;

    public ElasticSearchIndexUpgradeSupport(ApplicationDirectories applicationDirectories) {
        Preconditions.checkNotNull((Object)applicationDirectories);
        this.nexusLsnFile = new File(applicationDirectories.getWorkDirectory("elasticsearch"), NEXUS_LSN);
    }

    public void apply() throws Exception {
        this.writeReindexMarker();
    }

    private void writeReindexMarker() throws IOException {
        this.log.info("Write reindex marker to Elasticsearch marker file");
        Throwable throwable = null;
        Object var2_3 = null;
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.nexusLsnFile));){
            out.writeBytes("INDEX_UPGRADE_MARKER");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

