/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.metadata.schema.OType;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;

@Named
@Singleton
@Upgrades(model="config", from="1.6", to="1.7")
public class ConfigDatabaseUpgrade_1_7
extends DatabaseUpgradeSupport {
    private static final String DB_NAME = "repository";
    private static final String P_ROUTING_RULE_ID = "routingRuleId";
    private Provider<DatabaseInstance> configDatabaseInstance;

    @Inject
    public ConfigDatabaseUpgrade_1_7(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> configDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
    }

    public void apply() throws Exception {
        ConfigDatabaseUpgrade_1_7.withDatabaseAndClass(this.configDatabaseInstance, (String)DB_NAME, (db, table) -> {
            if (!table.existsProperty(P_ROUTING_RULE_ID)) {
                table.createProperty(P_ROUTING_RULE_ID, OType.LINK);
            }
        });
    }
}

