/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="config", from="1.5", to="1.6")
public class ConfigDatabaseUpgrade_1_6
extends DatabaseUpgradeSupport {
    private static final String SELECTOR_CLASS_NAME = new OClassNameBuilder().prefix("selector").type("selector").build();
    private final Provider<DatabaseInstance> databaseInstance;

    @Inject
    public ConfigDatabaseUpgrade_1_6(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
    }

    public void apply() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            ORecordIteratorClass selectorDocuments = db.browseClass(SELECTOR_CLASS_NAME);
            selectorDocuments.forEach(selector -> {
                try {
                    selector.deserializeFields(new String[0]);
                }
                catch (Exception e) {
                    this.log.debug("Deleting broken record due to exception during deserialization", (Throwable)e);
                    this.deleteBrokenRecord(db, (ODocument)selector);
                    this.log.info("Deleted broken content selector {} ", (Object)selector.getIdentity().toString());
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void deleteBrokenRecord(ODatabaseDocumentTx db, ODocument selector) {
        ODocument replacement = new ODocument();
        replacement.field("name", (Object)((String)selector.field("name")));
        replacement.field("type", (Object)((String)selector.field("type")));
        replacement.field("description", (Object)((String)selector.field("description")));
        replacement.field("attributes", new HashMap());
        ORecordInternal.setVersion((ORecord)replacement, (int)selector.getVersion());
        ORecordInternal.setIdentity((ORecord)replacement, (ORecordId)((ORecordId)selector.getIdentity()));
        db.save((ORecord)replacement);
        db.delete(replacement.getRecord().getIdentity());
    }
}

