/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.collate.OCaseInsensitiveCollate;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="config", from="1.3", to="1.4")
public class ConfigDatabaseUpgrade_1_4
extends DatabaseUpgradeSupport {
    public static final String MIGRATED = "1_4_migrated";
    private static final String HEALTHCHECK_PROPERTIES = "healthcheck.properties";
    private static final String RHC_PROPERTY_FILE_CHARSET = Charsets.ISO_8859_1.name();
    static final String C_HEALTHCHECKCONFIG = new OClassNameBuilder().type("healthcheckconfig").build();
    private static final String P_PROPERTY_NAME = "property_name";
    static final String P_PROPERTY_VALUE = "property_value";
    private static final String I_PROPERTY_NAME = new OIndexNameBuilder().type(C_HEALTHCHECKCONFIG).property("property_name").build();
    static final OSQLSynchQuery<ODocument> PROPERTY_QUERY = new OSQLSynchQuery(String.format("SELECT FROM %s WHERE %s = ?", C_HEALTHCHECKCONFIG, "property_name"));
    private final Provider<DatabaseInstance> databaseInstance;
    private final ApplicationDirectories applicationDirectories;

    @Inject
    public ConfigDatabaseUpgrade_1_4(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance, ApplicationDirectories applicationDirectories) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
    }

    public void apply() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.upgradeSchema(db);
            this.migrateProperties(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void upgradeSchema(ODatabaseDocumentTx db) {
        OIndexManagerProxy indexManager;
        OProperty property;
        this.log.debug("Upgrading schema for Repository Health Check configuration");
        OSchemaProxy schema = db.getMetadata().getSchema();
        OClass type = schema.getClass(C_HEALTHCHECKCONFIG);
        if (type == null) {
            type = schema.createClass(C_HEALTHCHECKCONFIG);
            this.log.debug("Created type {}", (Object)type);
        }
        if (type.getProperty(P_PROPERTY_NAME) == null) {
            property = type.createProperty(P_PROPERTY_NAME, OType.STRING).setCollate((OCollate)new OCaseInsensitiveCollate()).setMandatory(true).setNotNull(true);
            this.log.debug("Created property {}", (Object)property);
        }
        if (type.getProperty(P_PROPERTY_VALUE) == null) {
            property = type.createProperty(P_PROPERTY_VALUE, OType.STRING).setCollate((OCollate)new OCaseInsensitiveCollate()).setMandatory(true).setNotNull(false);
            this.log.debug("Created property {}", (Object)property);
        }
        if ((indexManager = db.getMetadata().getIndexManager()).getIndex(I_PROPERTY_NAME) == null) {
            OIndex index = type.createIndex(I_PROPERTY_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_PROPERTY_NAME});
            this.log.debug("Created index {}", (Object)index);
        }
        this.log.debug("Created schema type {}: properties={}, indexes={}", new Object[]{type, type.properties(), type.getIndexes()});
    }

    private void migrateProperties(ODatabaseDocumentTx db) throws Exception {
        File propFile = new File(this.applicationDirectories.getWorkDirectory("etc"), HEALTHCHECK_PROPERTIES);
        if (propFile.exists()) {
            Properties properties = new Properties();
            Throwable throwable = null;
            Iterator<String> iterator = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(propFile), RHC_PROPERTY_FILE_CHARSET);){
                properties.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (!Boolean.parseBoolean(properties.getProperty(MIGRATED))) {
                this.log.info("migrating {} properties from {} into configuration database", (Object)properties.size(), (Object)propFile.getAbsolutePath());
                for (String name : this.uniqueCIPropertyNames(properties.stringPropertyNames())) {
                    String value = properties.getProperty(name);
                    ODocument config = (ODocument)Iterables.getFirst((Iterable)((Iterable)db.command(PROPERTY_QUERY).execute(new Object[]{name})), (Object)db.newInstance(C_HEALTHCHECKCONFIG).field(P_PROPERTY_NAME, (Object)name).field(P_PROPERTY_VALUE, (Object)value));
                    if (config == null) continue;
                    String current = (String)config.field(P_PROPERTY_VALUE);
                    if (current == null ? value != null : !current.equals(value)) {
                        config.field(P_PROPERTY_VALUE, (Object)value);
                    }
                    config.save();
                }
                properties.setProperty(MIGRATED, "true");
                throwable = null;
                iterator = null;
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(propFile), RHC_PROPERTY_FILE_CHARSET);){
                    properties.store(writer, "completed ConfigDatabaseUpgrade_1_4 at " + new Date());
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }
    }

    private Set<String> uniqueCIPropertyNames(Set<String> propertyNames) {
        Set caseInsensitiveNames = propertyNames.stream().map(Strings2::lower).distinct().collect(Collectors.toSet());
        if (caseInsensitiveNames.size() == propertyNames.size()) {
            this.log.debug("No duplicate properties (case insensitive)");
            return propertyNames;
        }
        this.log.debug("Found {} duplicate properties (case insensitive)", (Object)(propertyNames.size() - caseInsensitiveNames.size()));
        LinkedHashSet<String> filteredNames = new LinkedHashSet<String>();
        for (String propertyName : propertyNames) {
            String ciPropertyName = Strings2.lower((String)propertyName);
            if (caseInsensitiveNames.contains(ciPropertyName)) {
                filteredNames.add(propertyName);
                caseInsensitiveNames.remove(ciPropertyName);
                continue;
            }
            this.log.warn("Ignoring duplicate property name in {}: {}", (Object)HEALTHCHECK_PROPERTIES, (Object)propertyName);
        }
        return filteredNames;
    }
}

