/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="component", from="1.7", to="1.8")
public class ComponentDatabaseUpgrade_1_8
extends DatabaseUpgradeSupport {
    private static final String BROWSE_NODE = new OClassNameBuilder().type("browse_node").build();
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public ComponentDatabaseUpgrade_1_8(@Named(value="component") @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        ComponentDatabaseUpgrade_1_8.withDatabaseAndClass(this.componentDatabaseInstance, (String)BROWSE_NODE, (db, table) -> db.getMetadata().getSchema().dropClass(BROWSE_NODE));
    }
}

