/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.collate.OCaseInsensitiveCollate;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="component", from="1.4", to="1.5")
public class ComponentDatabaseUpgrade_1_5
extends DatabaseUpgradeSupport {
    private static final String COMPONENT_CLASS = new OClassNameBuilder().type("component").build();
    private static final String I_CI_NAME_CASE_INSENSITIVE = new OIndexNameBuilder().type(COMPONENT_CLASS).property("ci_name").caseInsensitive().build();
    private static final String I_NAME_CASE_INSENSITIVE = new OIndexNameBuilder().type(COMPONENT_CLASS).property("name").caseInsensitive().build();
    private static final int BATCH_SIZE = 500;
    private static final String SELECT_COMPONENT_BATCH_SQL = String.format("select from component where ci_name is null limit %d", 500);
    private OSQLQuery<ODocument> SELECT_COMPONENT_BATCH = new OSQLSynchQuery(SELECT_COMPONENT_BATCH_SQL);
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public ComponentDatabaseUpgrade_1_5(@Named(value="component") @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        ComponentDatabaseUpgrade_1_5.withDatabaseAndClass(this.componentDatabaseInstance, (String)COMPONENT_CLASS, (db, type) -> {
            this.createCaseInsensitiveNameField((OClass)type);
            this.createCaseInsensitiveNameCaseInsensitiveIndex((ODatabaseDocumentTx)db, (OClass)type);
            this.populateCaseInsensitiveNameField((ODatabaseDocumentTx)db);
            this.modifyCaseInsensitiveNameField((OClass)type);
            this.deleteNameCaseInsensitiveIndex((ODatabaseDocumentTx)db);
        });
    }

    private void createCaseInsensitiveNameField(OClass type) {
        this.log.info("Creating case-insensitive name field on component");
        if (!type.existsProperty("ci_name")) {
            type.createProperty("ci_name", OType.STRING).setCollate((OCollate)new OCaseInsensitiveCollate()).setMandatory(false).setNotNull(false);
        }
    }

    private void populateCaseInsensitiveNameField(ODatabaseDocumentTx db) {
        this.log.info("Populating case-insensitive name field on component, this could be a long-running operation");
        try {
            boolean hasRecords = true;
            while (hasRecords) {
                hasRecords = this.populateCaseInsensitiveNameFieldBatch(db);
            }
        }
        finally {
            db.rollback();
        }
    }

    private boolean populateCaseInsensitiveNameFieldBatch(ODatabaseDocumentTx db) {
        this.log.trace("Processing batch of {} component records...", (Object)500);
        db.begin();
        List components = db.query(this.SELECT_COMPONENT_BATCH, new Object[0]);
        if (components.isEmpty()) {
            return false;
        }
        for (ODocument component : components) {
            String name = (String)component.field("name", String.class);
            component.field("ci_name", (Object)name.toLowerCase(Locale.ENGLISH));
            component.save();
        }
        db.commit();
        return true;
    }

    private void modifyCaseInsensitiveNameField(OClass type) {
        this.log.info("Modifying case-insensitive name field on component");
        OProperty ciNameProperty = type.getProperty("ci_name");
        if (!ciNameProperty.isMandatory()) {
            ciNameProperty.setMandatory(true);
        }
        if (!ciNameProperty.isNotNull()) {
            ciNameProperty.setNotNull(true);
        }
    }

    private void createCaseInsensitiveNameCaseInsensitiveIndex(ODatabaseDocumentTx db, OClass type) {
        this.log.info("Creating case-insensitive index on case-insensitive name field on component");
        OIndexManagerProxy indexManager = db.getMetadata().getIndexManager();
        if (indexManager.getIndex(I_CI_NAME_CASE_INSENSITIVE) == null) {
            new OIndexBuilder(type, I_CI_NAME_CASE_INSENSITIVE, OClass.INDEX_TYPE.NOTUNIQUE).property("ci_name", OType.STRING).caseInsensitive().build(db);
        }
    }

    private void deleteNameCaseInsensitiveIndex(ODatabaseDocumentTx db) {
        this.log.info("Deleting old case-insensitive name index on component");
        OIndexManagerProxy indexManager = db.getMetadata().getIndexManager();
        OIndex nameCaseInsensitiveIndex = indexManager.getIndex(I_NAME_CASE_INSENSITIVE);
        if (nameCaseInsensitiveIndex != null) {
            indexManager.dropIndex(I_NAME_CASE_INSENSITIVE);
        }
    }
}

