/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="component", from="1.3", to="1.4")
public class ComponentDatabaseUpgrade_1_4
extends DatabaseUpgradeSupport {
    public static final String COMPONENT_CLASS = new OClassNameBuilder().type("component").build();
    public static final String ASSET_CLASS = new OClassNameBuilder().type("asset").build();
    public static final String I_NAME_CASE_INSENSITIVE = new OIndexNameBuilder().type(COMPONENT_CLASS).property("name").caseInsensitive().build();
    public static final String I_COMPONENT = new OIndexNameBuilder().type(ASSET_CLASS).property("component").build();
    public static final String I_ASSET_NAME = new OIndexNameBuilder().type(ASSET_CLASS).property("name").caseInsensitive().build();
    public static final String I_COMPONENT_GROUP_NAME_VERSION = new OIndexNameBuilder().type(COMPONENT_CLASS).property("group").property("name").property("version").caseInsensitive().build();
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public ComponentDatabaseUpgrade_1_4(@Named(value="component") @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        ComponentDatabaseUpgrade_1_4.withDatabaseAndClass(this.componentDatabaseInstance, (String)ASSET_CLASS, (db, type) -> {
            this.createComponentIndex((ODatabaseDocumentTx)db, (OClass)type);
            this.createAssetNameIdx((ODatabaseDocumentTx)db, (OClass)type);
        });
        ComponentDatabaseUpgrade_1_4.withDatabaseAndClass(this.componentDatabaseInstance, (String)COMPONENT_CLASS, (db, type) -> {
            this.createNameCaseInsensitiveIndex((ODatabaseDocumentTx)db, (OClass)type);
            this.createComponentGroupNameVersionIdx((ODatabaseDocumentTx)db, (OClass)type);
        });
    }

    private void createNameCaseInsensitiveIndex(ODatabaseDocumentTx db, OClass type) {
        OIndexManagerProxy indexManager = db.getMetadata().getIndexManager();
        if (indexManager.getIndex(I_NAME_CASE_INSENSITIVE) == null) {
            new OIndexBuilder(type, I_NAME_CASE_INSENSITIVE, OClass.INDEX_TYPE.NOTUNIQUE).property("name", OType.STRING).caseInsensitive().build(db);
        }
    }

    private void createComponentIndex(ODatabaseDocumentTx db, OClass type) {
        if (db.getMetadata().getIndexManager().getIndex(I_COMPONENT) == null) {
            type.createIndex(I_COMPONENT, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{"component"});
        }
    }

    private void createAssetNameIdx(ODatabaseDocumentTx db, OClass type) {
        if (db.getMetadata().getIndexManager().getIndex(I_ASSET_NAME) == null) {
            new OIndexBuilder(type, I_ASSET_NAME, OClass.INDEX_TYPE.NOTUNIQUE).property("name", OType.STRING).caseInsensitive().build(db);
        }
    }

    private void createComponentGroupNameVersionIdx(ODatabaseDocumentTx db, OClass type) {
        if (db.getMetadata().getIndexManager().getIndex(I_COMPONENT_GROUP_NAME_VERSION) == null) {
            new OIndexBuilder(type, I_COMPONENT_GROUP_NAME_VERSION, OClass.INDEX_TYPE.NOTUNIQUE).property("group", OType.STRING).property("name", OType.STRING).property("version", OType.STRING).caseInsensitive().build(db);
        }
    }
}

