/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="component", from="1.15", to="1.16")
public class ComponentDatabaseUpgrade_1_16
extends DatabaseUpgradeSupport {
    private static final String RID = "rid";
    public static final String ASSET_CLASS = new OClassNameBuilder().type("asset").build();
    private static final String I_BUCKET_RID = new OIndexNameBuilder().type(ASSET_CLASS).property("bucket").property("rid").build();
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public ComponentDatabaseUpgrade_1_16(@Named(value="component") @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        ComponentDatabaseUpgrade_1_16.withDatabaseAndClass(this.componentDatabaseInstance, (String)ASSET_CLASS, (db, type) -> {
            if (db.getMetadata().getIndexManager().getIndex(I_BUCKET_RID) == null) {
                type.createIndex(I_BUCKET_RID, OClass.INDEX_TYPE.UNIQUE.name(), new String[]{"bucket", "@rid"});
            }
        });
    }
}

