/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="component", from="1.12", to="1.13")
public class ComponentDatabaseUpgrade_1_13
extends DatabaseUpgradeSupport {
    private static final String DB_CLASS = new OClassNameBuilder().type("assetdownloadcount").build();
    private Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public ComponentDatabaseUpgrade_1_13(@Named(value="component") @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        ComponentDatabaseUpgrade_1_13.withDatabaseAndClass(this.componentDatabaseInstance, (String)DB_CLASS, this::dropClass);
    }

    private void dropClass(ODatabaseDocumentTx db, OClass type) {
        db.command((OCommandRequest)new OCommandSQL("DROP CLASS " + type.getName() + " IF EXISTS")).execute(new Object[0]);
    }
}

