/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="component", from="1.10", to="1.11")
@DependsOn(model="config", version="1.5")
public class ComponentDatabaseUpgrade_1_11
extends DatabaseUpgradeSupport {
    private final Provider<DatabaseInstance> configDatabaseInstance;
    private final Provider<DatabaseInstance> componentDatabaseInstance;
    private static final String SELECT_DOCKER_REPOSITORIES = "select from repository where recipe_name in ['docker-hosted', 'docker-proxy']";
    private static final String P_REPOSITORY_NAME = "repository_name";
    private static final String C_BROWSE_NODE = "browse_node";
    private static final String BROWSE_NODE_CLASS = new OClassNameBuilder().type("browse_node").build();
    private static final String DELETE_BROWSE_NODE_FROM_REPOSITORIES = String.format("delete from %s where repository_name in ?", BROWSE_NODE_CLASS);

    @Inject
    public ComponentDatabaseUpgrade_1_11(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> configDatabaseInstance, @Named(value="component") @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        List repositoryNames;
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx configDb = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            repositoryNames = configDb.query((OQuery)new OSQLSynchQuery(SELECT_DOCKER_REPOSITORIES), new Object[0]).stream().map(d -> (String)d.field(P_REPOSITORY_NAME)).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (repositoryNames != null && !repositoryNames.isEmpty()) {
            this.log.info("Deleting browse_node data from docker repositories to be rebuilt ({}).", repositoryNames);
            throwable = null;
            var3_4 = null;
            try (ODatabaseDocumentTx componentDb = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
                OSchemaProxy schema = componentDb.getMetadata().getSchema();
                if (schema.existsClass(C_BROWSE_NODE)) {
                    componentDb.command((OCommandRequest)new OCommandSQL(DELETE_BROWSE_NODE_FROM_REPOSITORIES)).execute(new Object[]{repositoryNames});
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }
}

