/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.tools.orient;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.tools.OrphanedBlobFinder;

@Priority(value=0x7FFFFFFF)
@Named
public class OrientOrphanedBlobFinder
extends ComponentSupport
implements OrphanedBlobFinder {
    private final RepositoryManager repositoryManager;
    private final BlobStoreManager blobStoreManager;

    @Inject
    public OrientOrphanedBlobFinder(RepositoryManager repositoryManager, BlobStoreManager blobStoreManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    public void delete() {
        this.log.info("Starting delete of orphaned blobs for all known blob stores");
        this.blobStoreManager.browse().forEach(this::delete);
        this.log.info("Finished deleting orphaned blobs");
    }

    public void delete(Repository repository) {
        this.log.info("Starting delete of orphaned blobs for {}", (Object)repository.getName());
        this.delete(this.getBlobStoreForRepository(repository));
        this.log.info("Finished deleting orphaned blobs for {}", (Object)repository.getName());
    }

    private void delete(BlobStore blobStore) {
        this.detect(blobStore, (String blobId) -> {
            this.log.info("Deleting orphaned blob {} from blobstore {}", blobId, (Object)blobStore.getBlobStoreConfiguration().getName());
            blobStore.deleteHard(new BlobId(blobId));
        });
    }

    public void detect(Repository repository, Consumer<String> handler) {
        this.validateRepositoryConfiguration(repository);
        this.detect(this.getBlobStoreForRepository(repository), handler);
    }

    private void detect(BlobStore blobStore, Consumer<String> handler) {
        Stream blobIds = blobStore.getBlobIdStream();
        blobIds.forEach(id -> {
            BlobAttributes attributes = blobStore.getBlobAttributes(id);
            if (attributes != null) {
                this.checkIfOrphaned(handler, (BlobId)id, attributes);
            } else {
                this.log.warn("Skipping cleanup for blob {} because blob properties not found", id);
            }
        });
    }

    private void checkIfOrphaned(Consumer<String> handler, BlobId id, BlobAttributes attributes) {
        String repositoryName = (String)attributes.getHeaders().get("Bucket.repo-name");
        if (repositoryName != null) {
            String assetName = (String)attributes.getHeaders().get("BlobStore.blob-name");
            Repository repository = this.repositoryManager.get(repositoryName);
            if (repository == null) {
                this.log.debug("Blob {} considered orphaned because repository with name {} no longer exists", (Object)id.asUniqueString(), (Object)repositoryName);
                handler.accept(id.asUniqueString());
            } else {
                this.findAssociatedAsset(assetName, repository).ifPresent(asset -> {
                    BlobRef blobRef = asset.blobRef();
                    if (blobRef != null && !blobRef.getBlobId().asUniqueString().equals(id.asUniqueString())) {
                        if (!attributes.isDeleted()) {
                            handler.accept(id.asUniqueString());
                        } else {
                            this.log.debug("Blob {} in repository {} not considered orphaned because it is already marked soft-deleted", (Object)id.asUniqueString(), (Object)repositoryName);
                        }
                    }
                });
            }
        }
    }

    private BlobStore getBlobStoreForRepository(Repository repository) {
        String blobStoreName = (String)((Map)repository.getConfiguration().getAttributes().get("storage")).get("blobStoreName");
        return this.blobStoreManager.get(blobStoreName);
    }

    private Optional<Asset> findAssociatedAsset(String assetName, Repository repository) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (StorageTx tx = ((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            tx.begin();
            return Optional.ofNullable(tx.findAssetWithProperty("name", (Object)assetName, tx.findBucket(repository)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void validateRepositoryConfiguration(Repository repository) {
        Preconditions.checkArgument((repository.getConfiguration().getAttributes() != null ? 1 : 0) != 0, (Object)("Repository configuration not found " + repository.getName()));
        Preconditions.checkArgument((repository.getConfiguration().getAttributes().get("storage") != null ? 1 : 0) != 0, (Object)("No storage configuration found for the repository " + repository.getName()));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)((String)((Map)repository.getConfiguration().getAttributes().get("storage")).get("blobStoreName"))), (Object)("Blob store name not set for repository " + repository.getName()));
    }
}

