/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.storage.StorageFacetManager;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
@TaskLogging(value=TaskLogType.NEXUS_LOG_ONLY)
public class StorageFacetCleanupTask
extends TaskSupport
implements Cancelable {
    private final StorageFacetManager storageFacetManager;
    private volatile Thread thread;

    @Inject
    public StorageFacetCleanupTask(StorageFacetManager storageFacetManager) {
        this.storageFacetManager = (StorageFacetManager)Preconditions.checkNotNull((Object)storageFacetManager);
    }

    protected Void execute() throws Exception {
        long count;
        this.thread = Thread.currentThread();
        while ((count = this.storageFacetManager.performDeletions()) > 0L && !this.isCanceled()) {
        }
        return null;
    }

    public void cancel() {
        super.cancel();
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public String getMessage() {
        return "Reclaim storage for deleted repositories";
    }
}

