/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentCreatedEvent;
import org.sonatype.nexus.repository.storage.ComponentDeletedEvent;
import org.sonatype.nexus.repository.storage.ComponentEvent;
import org.sonatype.nexus.repository.storage.ComponentUpdatedEvent;

@Named
@Singleton
public class ComponentAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "repository.component";

    public ComponentAuditor() {
        this.registerType(ComponentCreatedEvent.class, "created");
        this.registerType(ComponentDeletedEvent.class, "deleted");
        this.registerType(ComponentUpdatedEvent.class, "updated");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ComponentEvent event) {
        if (this.isRecording() && event.isLocal()) {
            Component component = event.getComponent();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext(component.name());
            Map attributes = data.getAttributes();
            attributes.put("repository.name", event.getRepositoryName());
            attributes.put("format", component.format());
            attributes.put("name", component.name());
            attributes.put("group", component.group());
            attributes.put("version", component.version());
            this.record(data);
        }
    }
}

