/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.validation.ConstraintViolation;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.MultiHashingInputStream;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardAspect;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.move.RepositoryMoveService;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.BlobMetadataStorage;
import org.sonatype.nexus.repository.storage.BlobTx;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketEntityAdapter;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;
import org.sonatype.nexus.repository.storage.ComponentFactory;
import org.sonatype.nexus.repository.storage.ContentValidatorSelector;
import org.sonatype.nexus.repository.storage.MimeRulesSourceSelector;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageFacetManager;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.StorageTxImpl;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.storage.WritePolicySelector;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlobPayload;
import org.sonatype.nexus.security.ClientInfo;
import org.sonatype.nexus.security.ClientInfoProvider;
import org.sonatype.nexus.validation.ConstraintViolationFactory;
import org.sonatype.nexus.validation.ConstraintViolations;

@Named(value="default")
public class StorageFacetImpl
extends FacetSupport
implements StorageFacet {
    private final NodeAccess nodeAccess;
    private final BlobStoreManager blobStoreManager;
    private final Provider<DatabaseInstance> databaseInstanceProvider;
    private final BucketEntityAdapter bucketEntityAdapter;
    private final ComponentEntityAdapter componentEntityAdapter;
    private final AssetEntityAdapter assetEntityAdapter;
    private final ClientInfoProvider clientInfoProvider;
    private final ContentValidatorSelector contentValidatorSelector;
    private final MimeRulesSourceSelector mimeRulesSourceSelector;
    private final Supplier<StorageTx> txSupplier;
    private final StorageFacetManager storageFacetManager;
    private final ComponentFactory componentFactory;
    private final ConstraintViolationFactory constraintViolationFactory;
    private final Provider<RepositoryMoveService> repositoryMoveStoreProvider;
    private final BlobMetadataStorage blobMetadataStorage;
    private Config config;
    private WritePolicySelector writePolicySelector;

    @Inject
    public StorageFacetImpl(NodeAccess nodeAccess, BlobStoreManager blobStoreManager, @Named(value="component") @Named(value="component") Provider<DatabaseInstance> databaseInstanceProvider, BucketEntityAdapter bucketEntityAdapter, ComponentEntityAdapter componentEntityAdapter, AssetEntityAdapter assetEntityAdapter, ClientInfoProvider clientInfoProvider, ContentValidatorSelector contentValidatorSelector, MimeRulesSourceSelector mimeRulesSourceSelector, StorageFacetManager storageFacetManager, ComponentFactory componentFactory, ConstraintViolationFactory constraintViolationFactory, Provider<RepositoryMoveService> repositoryMoveStoreProvider, BlobMetadataStorage blobMetadataStorage) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.databaseInstanceProvider = (Provider)Preconditions.checkNotNull(databaseInstanceProvider);
        this.bucketEntityAdapter = (BucketEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)bucketEntityAdapter)));
        this.componentEntityAdapter = (ComponentEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)componentEntityAdapter)));
        this.assetEntityAdapter = (AssetEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)assetEntityAdapter)));
        this.clientInfoProvider = (ClientInfoProvider)Preconditions.checkNotNull((Object)clientInfoProvider);
        this.contentValidatorSelector = (ContentValidatorSelector)((Object)Preconditions.checkNotNull((Object)((Object)contentValidatorSelector)));
        this.mimeRulesSourceSelector = (MimeRulesSourceSelector)((Object)Preconditions.checkNotNull((Object)((Object)mimeRulesSourceSelector)));
        this.storageFacetManager = (StorageFacetManager)Preconditions.checkNotNull((Object)storageFacetManager);
        this.componentFactory = (ComponentFactory)Preconditions.checkNotNull((Object)componentFactory);
        this.constraintViolationFactory = (ConstraintViolationFactory)Preconditions.checkNotNull((Object)constraintViolationFactory);
        this.repositoryMoveStoreProvider = (Provider)Preconditions.checkNotNull(repositoryMoveStoreProvider);
        this.blobMetadataStorage = (BlobMetadataStorage)Preconditions.checkNotNull((Object)blobMetadataStorage);
        this.txSupplier = () -> this.openStorageTx(((DatabaseInstance)databaseInstanceProvider.get()).acquire());
    }

    protected void doValidate(Configuration configuration) throws Exception {
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, "storage", Config.class, new Class[]{Default.class, this.getRepository().getType().getValidationGroup()});
        Config configToValidate = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, "storage", Config.class);
        HashSet violations = new HashSet();
        ConstraintViolations.maybeAdd(violations, (ConstraintViolation[])new ConstraintViolation[]{this.validateBlobStoreExists(configToValidate.blobStoreName)});
        ConstraintViolations.maybeAdd(violations, (ConstraintViolation[])new ConstraintViolation[]{this.validateBlobStoreNotInGroup(configToValidate.blobStoreName)});
        ConstraintViolations.maybePropagate(violations, (Logger)this.log);
    }

    ConstraintViolation<?> validateBlobStoreExists(String blobStoreName) {
        return !this.blobStoreManager.exists(blobStoreName) ? this.constraintViolationFactory.createViolation(String.format("%s.%s.blobStoreName", "attributes", "storage"), String.format("Blob Store '%s' does not exist", blobStoreName)) : null;
    }

    ConstraintViolation<?> validateBlobStoreNotInGroup(String blobStoreName) {
        return this.blobStoreManager.getParent(blobStoreName).map(groupName -> this.constraintViolationFactory.createViolation(String.format("%s.%s.blobStoreName", "attributes", "storage"), String.format("Blob Store '%s' is a member of Blob Store Group '%s' and cannot be set as storage", blobStoreName, groupName))).orElse(null);
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, "storage", Config.class);
        this.log.debug("Config: {}", (Object)this.config);
    }

    protected void doInit(Configuration configuration) throws Exception {
        this.initBucket();
        this.writePolicySelector = WritePolicySelector.DEFAULT;
        super.doInit(configuration);
    }

    private void initBucket() {
        OrientTransactional.inTxRetry(this.databaseInstanceProvider).run(db -> {
            String repositoryName = this.getRepository().getName();
            Bucket bucket = this.bucketEntityAdapter.read(db, repositoryName);
            if (bucket == null) {
                bucket = new Bucket();
                bucket.setRepositoryName(repositoryName);
                bucket.attributes(new NestedAttributesMap("attributes", new HashMap()));
                this.bucketEntityAdapter.addEntity(db, (Entity)bucket);
            }
        });
    }

    protected void doDestroy() throws Exception {
        this.config = null;
    }

    protected void doDelete() throws Exception {
        if (!EventHelper.isReplicating()) {
            OrientTransactional.inTxRetry(this.databaseInstanceProvider).run(db -> {
                Bucket bucket = this.bucketEntityAdapter.read(db, this.getRepository().getName());
                this.storageFacetManager.enqueueDeletion(this.getRepository(), this.blobStoreManager.get(this.config.blobStoreName), bucket);
            });
        }
    }

    @Override
    @Guarded(by={"INITIALISED", "ATTACHED"})
    public void registerWritePolicySelector(WritePolicySelector writePolicySelector) {
        Preconditions.checkNotNull((Object)writePolicySelector);
        this.writePolicySelector = writePolicySelector;
    }

    @Override
    @Guarded(by={"STARTED"})
    public Supplier<StorageTx> txSupplier() {
        return this.txSupplier;
    }

    @Override
    public TempBlob createTempBlob(InputStream inputStream, Iterable<HashAlgorithm> hashAlgorithms) {
        BlobStore blobStore = (BlobStore)Preconditions.checkNotNull((Object)this.blobStoreManager.get(this.config.blobStoreName));
        MultiHashingInputStream hashingStream = new MultiHashingInputStream(hashAlgorithms, inputStream);
        Blob blob = blobStore.create((InputStream)hashingStream, this.tempHeaders());
        return new TempBlob(blob, hashingStream.hashes(), true, blobStore);
    }

    @Override
    public TempBlob createTempBlob(Payload payload, Iterable<HashAlgorithm> hashAlgorithms) {
        if (payload instanceof TempBlobPayload) {
            return (TempBlob)((TempBlobPayload)payload).getTempBlob();
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = payload.openInputStream();){
                return this.createTempBlob(inputStream, (Iterable)hashAlgorithms);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TempBlob createTempBlob(Path path, Iterable<HashAlgorithm> hashAlgorithms, boolean requireHardLink) {
        try {
            Blob blob;
            BlobStore blobStore = (BlobStore)Preconditions.checkNotNull((Object)this.blobStoreManager.get(this.config.blobStoreName));
            Map<HashAlgorithm, HashCode> hashes = this.computeHashes(path, hashAlgorithms);
            Map<String, String> headers = this.tempHeaders();
            try {
                blob = blobStore.create(path, headers, Files.size(path), hashes.get(HashAlgorithm.SHA1));
            }
            catch (Exception e) {
                if (requireHardLink) {
                    throw e;
                }
                this.log.debug("Failed to hard-link {}", (Object)path);
                Throwable throwable = null;
                Object var10_12 = null;
                try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                    blob = blobStore.create((InputStream)in, headers);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return new TempBlob(blob, hashes, true, blobStore);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Loose catch block
     */
    private Map<HashAlgorithm, HashCode> computeHashes(Path path, Iterable<HashAlgorithm> hashing) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Map map;
                MultiHashingInputStream hashingStream;
                BufferedInputStream in;
                block18: {
                    block17: {
                        in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
                        hashingStream = new MultiHashingInputStream(hashing, (InputStream)in);
                        IOUtils.consume((InputStream)hashingStream);
                        map = hashingStream.hashes();
                        if (hashingStream == null) break block17;
                        hashingStream.close();
                    }
                    if (in == null) break block18;
                    ((InputStream)in).close();
                }
                return map;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (hashingStream != null) {
                                hashingStream.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Map<String, String> tempHeaders() {
        return ImmutableMap.of((Object)"BlobStore.blob-name", (Object)"temp", (Object)"BlobStore.created-by", (Object)this.createdBy(), (Object)"BlobStore.created-by-ip", (Object)this.createdByIp(), (Object)"BlobStore.temporary-blob", (Object)"");
    }

    @Nonnull
    private String createdBy() {
        ClientInfo clientInfo = this.clientInfoProvider.getCurrentThreadClientInfo();
        if (clientInfo == null || clientInfo.getUserid() == null) {
            return "system";
        }
        return clientInfo.getUserid();
    }

    @Nonnull
    private String createdByIp() {
        ClientInfo clientInfo = this.clientInfoProvider.getCurrentThreadClientInfo();
        if (clientInfo == null || clientInfo.getRemoteIP() == null) {
            return "system";
        }
        return clientInfo.getRemoteIP();
    }

    @Nonnull
    private StorageTx openStorageTx(ODatabaseDocumentTx db) {
        BlobStore blobStore = this.blobStoreManager.get(this.config.blobStoreName);
        return (StorageTx)StateGuardAspect.around((Object)new StorageTxImpl(this.createdBy(), this.createdByIp(), new BlobTx(this.nodeAccess, blobStore, this.blobMetadataStorage), db, this.getRepository().getName(), this.config.writePolicy == null ? WritePolicy.ALLOW : this.config.writePolicy, this.writePolicySelector, this.bucketEntityAdapter, this.componentEntityAdapter, this.assetEntityAdapter, this.config.strictContentTypeValidation, this.contentValidatorSelector.validator(this.getRepository()), this.mimeRulesSourceSelector.ruleSource(this.getRepository()), this.componentFactory, this.repositoryMoveStoreProvider, this.nodeAccess));
    }

    @Override
    public BlobStore blobStore() {
        return this.blobStoreManager.get(this.config.blobStoreName);
    }

    @VisibleForTesting
    static class Config {
        @NotEmpty
        public String blobStoreName;
        @NotNull(groups={HostedType.ValidationGroup.class})
        public WritePolicy writePolicy;
        @NotNull
        public Boolean strictContentTypeValidation = Boolean.TRUE;

        Config() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "blobStoreName='" + this.blobStoreName + '\'' + ", writePolicy=" + this.writePolicy + ", strictContentTypeValidation=" + this.strictContentTypeValidation + '}';
        }
    }
}

