/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.AssetStore;
import org.sonatype.nexus.repository.storage.RebuildAssetUploadMetadataConfiguration;
import org.sonatype.nexus.scheduling.TaskInterruptedException;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class RebuildAssetUploadMetadataTask
extends TaskSupport {
    private final AssetStore assetStore;
    private final BlobStoreManager blobStoreManager;
    private final int limit;

    @Inject
    public RebuildAssetUploadMetadataTask(AssetStore assetStore, BlobStoreManager blobStoreManager, RebuildAssetUploadMetadataConfiguration configuration) {
        this.assetStore = (AssetStore)Preconditions.checkNotNull((Object)assetStore);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.limit = ((RebuildAssetUploadMetadataConfiguration)Preconditions.checkNotNull((Object)configuration)).getPageSize();
    }

    public String getMessage() {
        return "Rebuild asset upload metadata";
    }

    /*
     * Unable to fully structure code
     */
    protected Object execute() {
        totalAssets = this.assetStore.countAssets(null);
        processedAssets = 0L;
        assetCursor = this.assetStore.getIndex(AssetEntityAdapter.I_BUCKET_COMPONENT_NAME).cursor();
        progressLogger = new ProgressLogIntervalHelper(this.log, 60);
        assets = this.assetStore.getNextPage(assetCursor, this.limit);
        if (Iterables.isEmpty(assets) || Strings2.isBlank((String)this.assetStore.getById(assets.get(0).getValue()).createdBy())) ** GOTO lbl14
        return null;
lbl-1000:
        // 1 sources

        {
            this.checkContinuation();
            assetIds = assets.stream().map((Function<Map.Entry, EntityId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Ljava/util/Map$Entry;)Lorg/sonatype/nexus/common/entity/EntityId;)()).collect(Collectors.toList());
            assetsToUpdate = Streams.stream(this.assetStore.getByIds(assetIds)).filter((Predicate<Asset>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$1(org.sonatype.nexus.repository.storage.Asset ), (Lorg/sonatype/nexus/repository/storage/Asset;)Z)()).filter((Predicate<Asset>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$2(org.sonatype.nexus.repository.storage.Asset ), (Lorg/sonatype/nexus/repository/storage/Asset;)Z)()).map((Function<Asset, Asset>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$3(org.sonatype.nexus.repository.storage.Asset ), (Lorg/sonatype/nexus/repository/storage/Asset;)Lorg/sonatype/nexus/repository/storage/Asset;)((RebuildAssetUploadMetadataTask)this)).collect(Collectors.toList());
            this.assetStore.save(assetsToUpdate);
            progressLogger.info("{} / {} asset upload metadata processed in {} ms", new Object[]{processedAssets += (long)Iterables.size((Iterable)assetsToUpdate), totalAssets, progressLogger.getElapsed()});
            assets = this.assetStore.getNextPage(assetCursor, this.limit);
lbl14:
            // 2 sources

            ** while (assets != null && !assets.isEmpty())
        }
lbl15:
        // 1 sources

        progressLogger.flush();
        return null;
    }

    private void checkContinuation() {
        if (this.isCanceled()) {
            throw new TaskInterruptedException("Rebuilding asset upload metadata was cancelled", true);
        }
    }

    private static /* synthetic */ boolean lambda$1(Asset asset) {
        return Strings2.isEmpty((String)asset.createdBy());
    }

    private static /* synthetic */ boolean lambda$2(Asset asset) {
        return asset.blobRef() != null;
    }

    private /* synthetic */ Asset lambda$3(Asset asset) {
        BlobStore blobStore = this.blobStoreManager.get(asset.blobRef().getStore());
        Blob blob = blobStore.get(asset.blobRef().getBlobId());
        if (blob != null) {
            asset.createdBy((String)blob.getHeaders().get("BlobStore.created-by"));
            asset.createdByIp((String)blob.getHeaders().get("BlobStore.created-by-ip"));
            asset.blobCreated(blob.getMetrics().getCreationTime());
        }
        return asset;
    }
}

