/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class OrientReplicationIngestionService
extends ComponentSupport {
    @TransactionalStoreBlob
    public Component replicateComponent(Repository repository, String name, String version, @Nullable String group, NestedAttributesMap componentAttributes) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(repository);
        Component component = OrientReplicationIngestionService.findComponent(repository, name, version, group);
        if (component == null) {
            component = (Component)((Component)tx.createComponent(bucket, repository.getFormat()).name(name)).version(version).group(group).attributes(componentAttributes);
            tx.saveComponent(component);
        } else {
            NestedAttributesMap currentAttributes = component.attributes();
            if (this.shouldSaveAttributes(currentAttributes, componentAttributes)) {
                component.attributes(componentAttributes);
                tx.saveComponent(component);
            }
        }
        return component;
    }

    @Nullable
    private static Component findComponent(Repository repository, String name, String version, @Nullable String group) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Query.Builder query = Query.builder().where("name").eq(name).and("version").eq(version);
        if (group != null) {
            query = query.and("group").eq(group);
        }
        return (Component)Iterables.getFirst(tx.findComponents(query.build(), Collections.singletonList(repository)), null);
    }

    private boolean shouldSaveAttributes(NestedAttributesMap currentAttributes, NestedAttributesMap componentAttributes) {
        return !currentAttributes.isEmpty() || !componentAttributes.isEmpty();
    }

    public Asset replicateAsset(Repository repository, String name, NestedAttributesMap attributes, AssetBlob blob) {
        return this.replicateAsset(repository, name, attributes, blob, null);
    }

    @TransactionalStoreBlob
    public Asset replicateAsset(Repository repository, String name, NestedAttributesMap attributes, AssetBlob blob, @Nullable Component component) {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.findAsset(tx, bucket = tx.findBucket(repository), name);
        if (asset == null) {
            asset = component != null ? (Asset)tx.createAsset(bucket, component).name(name) : (Asset)tx.createAsset(bucket, repository.getFormat()).name(name);
        }
        blob.setReplicated(true);
        tx.attachBlob(asset, blob);
        asset.attributes(attributes);
        tx.saveAsset(asset);
        return asset;
    }

    @Nullable
    private Asset findAsset(StorageTx tx, Bucket bucket, String name) {
        return tx.findAssetWithProperty("name", (Object)name, bucket);
    }

    @TransactionalDeleteBlob
    public boolean replicateDeleteAsset(Repository repository, String name) {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.findAsset(tx, bucket = tx.findBucket(repository), name);
        if (asset != null) {
            Component component;
            tx.deleteAsset(asset, true);
            if (asset.componentId() != null && (component = tx.findComponent(asset.componentId())) != null && Iterables.isEmpty(tx.browseAssets(component))) {
                tx.deleteComponent(component, true);
            }
            return true;
        }
        return false;
    }
}

