/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.Hashes;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.replication.ReplicationIngesterHelper;
import org.sonatype.nexus.repository.replication.ReplicationIngestionException;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.ReplicationFacet;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="orient")
@Singleton
public class OrientReplicationIngesterHelper
extends ComponentSupport
implements ReplicationIngesterHelper {
    private final BlobStoreManager blobStoreManager;
    private final NodeAccess nodeAccess;
    private final RepositoryManager repositoryManager;

    @Inject
    public OrientReplicationIngesterHelper(BlobStoreManager blobStoreManager, NodeAccess nodeAccess, RepositoryManager repositoryManager) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public void replicate(String blobStoreId, Blob blob, Map<String, Object> assetAttributes, Map<String, Object> componentAttributes, String repositoryName, String blobStoreName) throws IOException {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            throw new ReplicationIngestionException(String.format("Can't replicate blob %s, the repository %s doesn't exist", blob.getId().toString(), repositoryName));
        }
        UnitOfWork.begin(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
        try {
            BlobStore blobStore = this.blobStoreManager.get(blobStoreId);
            BlobAttributes blobAttributes = blobStore.getBlobAttributes(blob.getId());
            blobAttributes.getHeaders().put("Bucket.repo-name", repositoryName);
            blobAttributes.store();
            AssetBlob assetBlob = new AssetBlob(this.nodeAccess, blobStore, store -> blob, (String)blobAttributes.getHeaders().get("BlobStore.content-type"), Hashes.hash((Iterable)ImmutableList.of((Object)HashAlgorithm.SHA1), (InputStream)blob.getInputStream()), true);
            ReplicationFacet replicationFacet = (ReplicationFacet)repository.facet(ReplicationFacet.class);
            replicationFacet.replicate((String)blobAttributes.getHeaders().get("BlobStore.blob-name"), assetBlob, new NestedAttributesMap("attributes", assetAttributes), new NestedAttributesMap("attributes", componentAttributes));
        }
        finally {
            UnitOfWork.end();
        }
    }

    public void deleteReplication(String path, String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            throw new ReplicationIngestionException(String.format("Can't delete blob in path %s as the repository %s doesn't exist", path, repositoryName));
        }
        UnitOfWork.begin(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
        try {
            ReplicationFacet replicationFacet = (ReplicationFacet)repository.facet(ReplicationFacet.class);
            replicationFacet.replicateDelete(path);
        }
        finally {
            UnitOfWork.end();
        }
    }
}

