/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLNonBlockingQuery;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;

class OrientAsyncHelper {
    private static final int BUFFER_SIZE = 128;
    private static final long DEFAULT_TIMEOUT_SECONDS = 60L;
    @VisibleForTesting
    static long queryTimeout = SystemPropertiesHelper.getLong((String)"nexus.orient.query.timeout.seconds", (long)60L);
    @VisibleForTesting
    static final ODocument SENTINEL = new ODocument();

    private OrientAsyncHelper() {
    }

    public static Iterable<ODocument> asyncIterable(ODatabaseDocumentTx db, String selectQuery, @Nullable Map<String, Object> parameters) {
        return OrientAsyncHelper.asyncIterable(db, selectQuery, parameters, 128, queryTimeout);
    }

    public static Iterable<ODocument> asyncIterable(ODatabaseDocumentTx db, String selectQuery, @Nullable Map<String, Object> parameters, int bufferSize, long timeoutSeconds) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)selectQuery);
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeoutSeconds >= 0L ? 1 : 0) != 0);
        ArrayBlockingQueue<ODocument> queue = new ArrayBlockingQueue<ODocument>(bufferSize);
        db.command((OCommandRequest)new OSQLNonBlockingQuery(selectQuery, (OCommandResultListener)new QueueFeedingResultListener(timeoutSeconds, queue))).execute(new Object[]{parameters});
        return new QueueConsumingIterable(timeoutSeconds, queue);
    }

    private static String queueIdentity(BlockingQueue<?> queue) {
        return Integer.toHexString(System.identityHashCode(queue));
    }

    @VisibleForTesting
    static final class QueueConsumingIterable
    extends ComponentSupport
    implements Iterable<ODocument>,
    Iterator<ODocument> {
        private final long timeoutSeconds;
        private final BlockingQueue<ODocument> queue;
        private ODocument next;

        public QueueConsumingIterable(long timeoutSeconds, BlockingQueue<ODocument> queue) {
            this.timeoutSeconds = timeoutSeconds;
            this.queue = queue;
        }

        @Override
        public Iterator<ODocument> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                try {
                    this.next = this.queue.poll(this.timeoutSeconds, TimeUnit.SECONDS);
                    if (this.next == null) {
                        throw new IllegalStateException("Timed out reading query result from queue " + OrientAsyncHelper.queueIdentity(this.queue) + " after " + this.timeoutSeconds + " seconds");
                    }
                }
                catch (InterruptedException e) {
                    this.log.warn("Interrupted poll", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            return this.next != SENTINEL;
        }

        @Override
        public ODocument next() {
            if (this.hasNext()) {
                ODocument doc = this.next;
                this.next = null;
                return doc;
            }
            throw new NoSuchElementException("Iterator depleted");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method not supported");
        }
    }

    @VisibleForTesting
    static final class QueueFeedingResultListener
    extends ComponentSupport
    implements OCommandResultListener {
        private final long timeoutSeconds;
        private final BlockingQueue<ODocument> queue;

        public QueueFeedingResultListener(long timeoutSeconds, BlockingQueue<ODocument> queue) {
            this.timeoutSeconds = timeoutSeconds;
            this.queue = queue;
        }

        public boolean result(Object o) {
            ODocument doc = (ODocument)o;
            try {
                if (!this.queue.offer(doc, this.timeoutSeconds, TimeUnit.SECONDS)) {
                    this.log.warn("Timed out adding query result to queue {} after {} seconds, aborting query", (Object)OrientAsyncHelper.queueIdentity(this.queue), (Object)this.timeoutSeconds);
                    return false;
                }
            }
            catch (InterruptedException e) {
                this.log.warn("Interrupted result", (Throwable)e);
                return false;
            }
            return true;
        }

        public void end() {
            try {
                if (!this.queue.offer(SENTINEL, this.timeoutSeconds, TimeUnit.SECONDS)) {
                    this.log.warn("Timed out adding end marker to queue {} after {} seconds", (Object)OrientAsyncHelper.queueIdentity(this.queue), (Object)this.timeoutSeconds);
                }
            }
            catch (InterruptedException e) {
                this.log.warn("Interrupted end", (Throwable)e);
            }
        }

        public Object getResult() {
            return null;
        }
    }
}

