/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentFinder;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;

@Singleton
@Named
public class DefaultComponentFinder
implements ComponentFinder {
    public static final String DEFAULT_COMPONENT_FINDER_KEY = "default";

    @Override
    public List<Component> findMatchingComponents(Repository repository, String componentId, String componentGroup, String componentName, String componentVersion) {
        if (repository == null || componentId == null || componentId.isEmpty()) {
            return Collections.emptyList();
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (StorageTx storageTx = ((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            storageTx.begin();
            Component component = storageTx.findComponent((EntityId)new DetachedEntityId(componentId));
            if (component != null) {
                return Collections.singletonList(component);
            }
            return Collections.emptyList();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

