/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Throwables;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import java.util.concurrent.Callable;

public final class DatabaseThreadUtils {
    public static <T> T withOtherDatabase(Callable<T> function) {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        try {
            T t = function.call();
            return t;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            ODatabaseRecordThreadLocal.INSTANCE.set(db);
        }
    }

    private DatabaseThreadUtils() {
    }
}

