/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import java.util.List;
import java.util.Map;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

public interface ComponentDirector {
    default public Component beforeMove(Component component, List<Asset> assets, Repository source, Repository destination) {
        return component;
    }

    default public Component afterMove(Component component, Repository destination) {
        return component;
    }

    default public boolean allowMoveTo(Repository destination) {
        return false;
    }

    default public boolean allowMoveTo(Component component, Repository destination) {
        return false;
    }

    default public boolean allowMoveFrom(Repository source) {
        return false;
    }

    default public void afterMove(List<Map<String, String>> components, Repository destination) {
    }

    default public boolean redeployAllowed(Repository destination, Component component) {
        return WritePolicy.ALLOW.name().equals(destination.getConfiguration().attributes("storage").get("writePolicy"));
    }
}

