/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketEntityAdapter;
import org.sonatype.nexus.repository.storage.BucketStore;

@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Named
public class BucketStoreImpl
extends StateGuardLifecycleSupport
implements BucketStore,
Lifecycle {
    private final Provider<DatabaseInstance> databaseInstance;
    private final BucketEntityAdapter entityAdapter;

    @Inject
    public BucketStoreImpl(@Named(value="component") @Named(value="component") Provider<DatabaseInstance> databaseInstance, BucketEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (BucketEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Bucket read(String repositoryName) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            return this.entityAdapter.read(db, repositoryName);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Bucket getById(EntityId bucketId) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).acquire();){
            return (Bucket)this.entityAdapter.read(db, bucketId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

