/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.InvalidStateException;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketEntityAdapter;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;

@Named
@Singleton
public class BucketDeleter
extends ComponentSupport {
    private static final long DELETE_BATCH_SIZE = 100L;
    private final Provider<DatabaseInstance> databaseInstanceProvider;
    private final BucketEntityAdapter bucketEntityAdapter;
    private final ComponentEntityAdapter componentEntityAdapter;
    private final AssetEntityAdapter assetEntityAdapter;
    private final BlobStoreManager blobStoreManager;

    @Inject
    public BucketDeleter(@Named(value="component") @Named(value="component") Provider<DatabaseInstance> databaseInstanceProvider, BucketEntityAdapter bucketEntityAdapter, ComponentEntityAdapter componentEntityAdapter, AssetEntityAdapter assetEntityAdapter, BlobStoreManager blobStoreManager) {
        this.databaseInstanceProvider = (Provider)Preconditions.checkNotNull(databaseInstanceProvider);
        this.bucketEntityAdapter = (BucketEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)bucketEntityAdapter)));
        this.componentEntityAdapter = (ComponentEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)componentEntityAdapter)));
        this.assetEntityAdapter = (AssetEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)assetEntityAdapter)));
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    public void deleteBucket(Bucket bucket) throws InterruptedException {
        Preconditions.checkNotNull((Object)((Object)bucket));
        OrientTransactional.inTxRetry(this.databaseInstanceProvider).throwing(InterruptedException.class).run(db -> {
            long count = 0L;
            ArrayList<BlobRef> deletedBlobs = new ArrayList<BlobRef>();
            HashSet<String> deletedBlobStores = new HashSet<String>();
            for (Component component : this.componentEntityAdapter.browseByBucket(db, bucket)) {
                this.deleteComponent(db, deletedBlobs, component);
                if (++count != 100L) continue;
                this.commitBatch(db, deletedBlobs, deletedBlobStores);
                count = 0L;
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            }
            this.commitBatch(db, deletedBlobs, deletedBlobStores);
            for (Asset asset : this.assetEntityAdapter.browseByBucket(db, bucket)) {
                this.deleteAsset(db, deletedBlobs, asset);
                if (++count != 100L) continue;
                this.commitBatch(db, deletedBlobs, deletedBlobStores);
                count = 0L;
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            }
            this.commitBatch(db, deletedBlobs, deletedBlobStores);
            this.bucketEntityAdapter.deleteEntity(db, (Entity)bucket);
            db.commit();
        });
    }

    private void deleteAsset(ODatabaseDocumentTx db, List<BlobRef> deletedBlobs, Asset asset) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull(deletedBlobs);
        Preconditions.checkNotNull((Object)asset);
        BlobRef ref = asset.blobRef();
        if (ref != null) {
            deletedBlobs.add(ref);
        }
        this.assetEntityAdapter.deleteEntity(db, asset);
    }

    private void deleteComponent(ODatabaseDocumentTx db, List<BlobRef> deletedBlobs, Component component) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull(deletedBlobs);
        Preconditions.checkNotNull((Object)component);
        for (Asset asset : this.assetEntityAdapter.browseByComponent(db, component)) {
            this.deleteAsset(db, deletedBlobs, asset);
        }
        this.componentEntityAdapter.deleteEntity(db, component);
    }

    private void commitBatch(ODatabaseDocumentTx db, List<BlobRef> deletedBlobs, Set<String> deletedBlobStores) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull(deletedBlobs);
        Preconditions.checkNotNull(deletedBlobStores);
        db.commit();
        for (BlobRef blobRef : deletedBlobs) {
            this.deleteBlob(deletedBlobStores, blobRef);
        }
        deletedBlobs.clear();
    }

    private void deleteBlob(Set<String> deletedBlobStores, BlobRef blobRef) {
        String blobStoreName = blobRef.getStore();
        if (deletedBlobStores.contains(blobStoreName)) {
            return;
        }
        BlobStore blobStore = this.blobStoreManager.get(blobRef.getStore());
        if (blobStore == null) {
            if (deletedBlobStores.add(blobStoreName)) {
                this.log.info("Not deleting blobs for blob store {}, blob store not found", (Object)blobStoreName);
            }
            return;
        }
        try {
            blobStore.delete(blobRef.getBlobId(), "Deleting Bucket");
        }
        catch (InvalidStateException e) {
            if (deletedBlobStores.add(blobStoreName)) {
                this.log.info("Not deleting blobs for blob store {}, invalid state {}", new Object[]{blobStoreName, e.getInvalidState(), this.log.isDebugEnabled() ? e : null});
            }
        }
        catch (Exception e) {
            this.log.warn("Error deleting blob {}, skipping", (Object)blobRef, (Object)e);
        }
    }
}

