/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.upgrade.orient;

import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.attributes.AttributesFacet;
import org.sonatype.nexus.repository.search.index.SearchUpdateService;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public class OrientSearchUpdateService
implements SearchUpdateService {
    public boolean needsReindex(Repository repository) {
        if ("group".equals(repository.getType().getValue())) {
            return false;
        }
        AttributesFacet attributesFacet = (AttributesFacet)repository.facet(AttributesFacet.class);
        Object indexOutdated = attributesFacet.getAttributes().get("search_index_outdated");
        if (indexOutdated instanceof Boolean) {
            return (Boolean)indexOutdated;
        }
        return false;
    }

    public void doneReindexing(Repository repository) {
        ((AttributesFacet)repository.facet(AttributesFacet.class)).modifyAttributes(attributes -> {
            Object object = attributes.remove("search_index_outdated");
        });
    }
}

