/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.search.ElasticSearchFacet;

final class IndexRequest {
    private final Set<EntityId> pendingDeletes;
    private final Set<EntityId> updatedIds = new HashSet<EntityId>();

    IndexRequest(Set<EntityId> pendingDeletes) {
        this.pendingDeletes = (Set)Preconditions.checkNotNull(pendingDeletes);
    }

    void update(EntityId componentId) {
        this.updatedIds.add(componentId);
    }

    void apply(ElasticSearchFacet elasticSearchFacet) {
        this.updatedIds.forEach(id -> {
            if (this.pendingDeletes.remove(id)) {
                elasticSearchFacet.delete((EntityId)id);
            } else {
                elasticSearchFacet.put((EntityId)id);
            }
        });
    }

    void bulkApply(ElasticSearchFacet elasticSearchFacet) {
        if (!this.pendingDeletes.isEmpty()) {
            HashSet<EntityId> deletedIds = new HashSet<EntityId>();
            Iterator<EntityId> itr = this.updatedIds.iterator();
            while (itr.hasNext()) {
                EntityId id = itr.next();
                if (!this.pendingDeletes.remove(id)) continue;
                deletedIds.add(id);
                itr.remove();
            }
            if (!deletedIds.isEmpty()) {
                elasticSearchFacet.bulkDelete(deletedIds);
            }
        }
        if (!this.updatedIds.isEmpty()) {
            elasticSearchFacet.bulkPut(this.updatedIds);
        }
    }
}

