/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Now;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class IndexRebuildManager
extends LifecycleSupport {
    private final NodeAccess nodeAccess;
    private final TaskScheduler taskScheduler;
    private final boolean autoRebuild;
    private volatile boolean rebuildAllIndexes = false;

    @Inject
    public IndexRebuildManager(NodeAccess nodeAccess, TaskScheduler taskScheduler, @Named(value="${nexus.elasticsearch.autoRebuild:-true}") @Named(value="${nexus.elasticsearch.autoRebuild:-true}") boolean autoRebuild) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.autoRebuild = autoRebuild;
    }

    public void rebuildAllIndexes() {
        this.rebuildAllIndexes = true;
    }

    protected void doStart() throws Exception {
        if (this.autoRebuild && this.rebuildAllIndexes) {
            this.rebuildAllIndexes = false;
            if (!this.hasAutoRebuildTask()) {
                this.log.info("Scheduling automatic rebuild of repository indexes");
                this.doRebuildAllIndexes();
            } else {
                this.log.info("Automatic rebuild of repository indexes is already scheduled");
            }
        }
    }

    private void doRebuildAllIndexes() {
        try {
            TaskConfiguration taskConfig = this.taskScheduler.createTaskConfigurationInstance("repository.rebuild-index");
            taskConfig.setString("repositoryName", "*");
            taskConfig.setString("limitnode", this.nodeAccess.getId());
            taskConfig.setBoolean("multinode", false);
            this.taskScheduler.submit(taskConfig);
        }
        catch (RuntimeException e) {
            this.log.warn("Problem scheduling automatic rebuild of repository indexes", (Throwable)e);
        }
    }

    private boolean hasAutoRebuildTask() {
        return this.taskScheduler.listsTasks().stream().filter(task -> task.getSchedule() instanceof Now).map(TaskInfo::getConfiguration).filter(config -> "repository.rebuild-index".equals(config.getTypeId())).filter(config -> "*".equals(config.getString("repositoryName"))).anyMatch(config -> this.nodeAccess.getId().equals(config.getString("limitnode")));
    }
}

