/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.orient.entity.AttachedEntityId;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.search.ComponentMetadataProducer;
import org.sonatype.nexus.repository.search.ElasticSearchFacet;
import org.sonatype.nexus.repository.search.index.ElasticSearchIndexService;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketEntityAdapter;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;
import org.sonatype.nexus.repository.storage.ComponentStore;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class ElasticSearchFacetImpl
extends FacetSupport
implements ElasticSearchFacet {
    private static final int PAGE_SIZE = 1000;
    private static final int BUCKET = 0;
    private final ElasticSearchIndexService elasticSearchIndexService;
    private final Map<String, ComponentMetadataProducer> componentMetadataProducers;
    private final ComponentEntityAdapter componentEntityAdapter;
    private final ComponentStore componentStore;
    private final BucketEntityAdapter bucketEntityAdapter;
    private Map<String, Object> repositoryMetadata;

    @Inject
    public ElasticSearchFacetImpl(ElasticSearchIndexService elasticSearchIndexService, Map<String, ComponentMetadataProducer> componentMetadataProducers, ComponentEntityAdapter componentEntityAdapter, ComponentStore componentStore, BucketEntityAdapter bucketEntityAdapter) {
        this.elasticSearchIndexService = (ElasticSearchIndexService)Preconditions.checkNotNull((Object)elasticSearchIndexService);
        this.componentMetadataProducers = (Map)Preconditions.checkNotNull(componentMetadataProducers);
        this.componentEntityAdapter = (ComponentEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)componentEntityAdapter)));
        this.componentStore = (ComponentStore)Preconditions.checkNotNull((Object)componentStore);
        this.bucketEntityAdapter = (BucketEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)bucketEntityAdapter)));
    }

    protected void doInit(Configuration configuration) throws Exception {
        this.repositoryMetadata = ImmutableMap.of((Object)"repository_name", (Object)this.getRepository().getName());
        super.doInit(configuration);
    }

    @Guarded(by={"STARTED"})
    public void rebuildIndex() {
        this.log.info("Rebuilding index of repository {}", (Object)this.getRepository().getName());
        this.elasticSearchIndexService.rebuildIndex(this.getRepository());
        UnitOfWork.begin(((StorageFacet)this.facet(StorageFacet.class)).txSupplier());
        try {
            this.rebuildComponentIndex();
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Transactional
    protected void rebuildComponentIndex() {
        block13: {
            try {
                Repository repository = this.getRepository();
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                Bucket bucket = tx.findBucket(repository);
                ORID bucketId = this.bucketEntityAdapter.recordIdentity((Entity)bucket);
                if (bucket == null) {
                    this.log.warn("Unable to rebuild search index for repository {}", (Object)repository.getName());
                    return;
                }
                long processed = 0L;
                long total = this.componentStore.countComponents((Iterable<Bucket>)ImmutableList.of((Object)((Object)bucket)));
                if (total <= 0L) break block13;
                Throwable throwable = null;
                Object var10_10 = null;
                try (ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);){
                    Stopwatch sw = Stopwatch.createStarted();
                    OIndexCursor cursor = this.componentStore.getIndex(ComponentEntityAdapter.I_BUCKET_GROUP_NAME_VERSION).cursor();
                    List nextPage = this.componentStore.getNextPage(cursor, 1000);
                    while (!Iterables.isEmpty(nextPage)) {
                        List<EntityId> componentIds = nextPage.stream().filter(entry -> bucketId.equals(((OCompositeKey)entry.getKey()).getKeys().get(0))).map(Map.Entry::getValue).collect(Collectors.toList());
                        this.bulkPut(componentIds);
                        long elapsed = sw.elapsed(TimeUnit.MILLISECONDS);
                        progressLogger.info("Indexed {} / {} {} components in {} ms", new Object[]{processed += (long)componentIds.size(), total, repository.getName(), elapsed});
                        nextPage = this.componentStore.getNextPage(cursor, 1000);
                    }
                    progressLogger.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.error("Unable to rebuild search index for repository {}", (Object)this.getRepository().getName(), (Object)e);
            }
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void put(EntityId componentId) {
        Preconditions.checkNotNull((Object)componentId);
        String json = this.json(componentId);
        if (json != null) {
            this.elasticSearchIndexService.put(this.getRepository(), this.identifier(componentId), json);
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void bulkPut(Iterable<EntityId> componentIds) {
        Preconditions.checkNotNull(componentIds);
        this.elasticSearchIndexService.bulkPut(this.getRepository(), componentIds, this::identifier, this::json);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void delete(EntityId componentId) {
        Preconditions.checkNotNull((Object)componentId);
        this.elasticSearchIndexService.delete(this.getRepository(), this.identifier(componentId));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void bulkDelete(Iterable<EntityId> componentIds) {
        Preconditions.checkNotNull(componentIds);
        this.elasticSearchIndexService.bulkDelete(this.getRepository(), Iterables.transform(componentIds, this::identifier));
    }

    protected void doStart() throws Exception {
        this.elasticSearchIndexService.createIndex(this.getRepository());
    }

    protected void doDelete() {
        this.elasticSearchIndexService.deleteIndex(this.getRepository());
    }

    @Nullable
    private EntityId componentId(@Nullable ODocument doc) {
        return doc != null ? new AttachedEntityId((EntityAdapter)this.componentEntityAdapter, doc.getIdentity()) : null;
    }

    private ComponentMetadataProducer producer(Component component) {
        Preconditions.checkNotNull((Object)component);
        String format = component.format();
        ComponentMetadataProducer producer = this.componentMetadataProducers.get(format);
        if (producer == null) {
            producer = this.componentMetadataProducers.get("default");
        }
        Preconditions.checkState((producer != null ? 1 : 0) != 0, (String)"Could not find a component metadata producer for format: %s", (Object)format);
        return producer;
    }

    @Nullable
    private String identifier(@Nullable EntityId componentId) {
        return componentId != null ? componentId.getValue() : null;
    }

    @Nullable
    @Transactional
    protected String json(@Nullable EntityId componentId) {
        if (componentId != null) {
            Component component = null;
            Iterable<Asset> assets = null;
            try {
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                component = (Component)this.componentEntityAdapter.read(tx.getDb(), componentId);
                if (component != null) {
                    assets = tx.browseAssets(component);
                    return this.producer(component).getMetadata(component, assets, this.repositoryMetadata);
                }
            }
            catch (Exception e) {
                EntityId loggedComponent;
                Object object = loggedComponent = component == null ? componentId : component;
                if (this.log.isDebugEnabled()) {
                    this.log.warn("Failed to create JSON document for component: {} assets: {}", new Object[]{loggedComponent, assets, e});
                }
                this.log.warn("Failed to create JSON document for component: {} assets: {} error: {}", new Object[]{loggedComponent, assets, e.getMessage()});
            }
        }
        return null;
    }
}

