/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.entity.ContinuationTokenHelper;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.BrowseService;
import org.sonatype.nexus.repository.maintenance.MaintenanceService;
import org.sonatype.nexus.repository.query.PageResult;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.rest.api.AssetXODescriptor;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.repository.rest.api.ComponentXOFactory;
import org.sonatype.nexus.repository.rest.api.RepositoryItemIDXO;
import org.sonatype.nexus.repository.rest.api.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.repository.rest.cma.AssetXOBuilder;
import org.sonatype.nexus.repository.rest.cma.ComponentsResourceExtension;
import org.sonatype.nexus.repository.rest.internal.resources.doc.ComponentsResourceDoc;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;
import org.sonatype.nexus.repository.upload.UploadConfiguration;
import org.sonatype.nexus.repository.upload.UploadManager;
import org.sonatype.nexus.rest.Page;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@FeatureFlag(name="nexus.orient.enabled")
@Named(value="default")
@Singleton
@Path(value="/v1/components")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ComponentsResource
extends ComponentSupport
implements Resource,
ComponentsResourceDoc {
    public static final String RESOURCE_URI = "/v1/components";
    private final RepositoryManagerRESTAdapter repositoryManagerRESTAdapter;
    private final BrowseService browseService;
    private final ComponentEntityAdapter componentEntityAdapter;
    private final MaintenanceService maintenanceService;
    private final ContinuationTokenHelper continuationTokenHelper;
    private final UploadManager uploadManager;
    private final UploadConfiguration uploadConfiguration;
    private final ComponentXOFactory componentXOFactory;
    private final Set<ComponentsResourceExtension> componentsResourceExtensions;
    private final Map<String, AssetXODescriptor> assetDescriptors;

    @Inject
    public ComponentsResource(RepositoryManagerRESTAdapter repositoryManagerRESTAdapter, BrowseService browseService, ComponentEntityAdapter componentEntityAdapter, MaintenanceService maintenanceService, @Named(value="component") @Named(value="component") ContinuationTokenHelper continuationTokenHelper, UploadManager uploadManager, UploadConfiguration uploadConfiguration, ComponentXOFactory componentXOFactory, Set<ComponentsResourceExtension> componentsResourceExtensions, @Nullable Map<String, AssetXODescriptor> assetDescriptors) {
        this.repositoryManagerRESTAdapter = (RepositoryManagerRESTAdapter)Preconditions.checkNotNull((Object)repositoryManagerRESTAdapter);
        this.browseService = (BrowseService)Preconditions.checkNotNull((Object)browseService);
        this.componentEntityAdapter = (ComponentEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)componentEntityAdapter)));
        this.maintenanceService = (MaintenanceService)Preconditions.checkNotNull((Object)maintenanceService);
        this.continuationTokenHelper = (ContinuationTokenHelper)Preconditions.checkNotNull((Object)continuationTokenHelper);
        this.uploadManager = (UploadManager)Preconditions.checkNotNull((Object)uploadManager);
        this.uploadConfiguration = (UploadConfiguration)Preconditions.checkNotNull((Object)uploadConfiguration);
        this.componentXOFactory = (ComponentXOFactory)Preconditions.checkNotNull((Object)componentXOFactory);
        this.componentsResourceExtensions = (Set)Preconditions.checkNotNull(componentsResourceExtensions);
        this.assetDescriptors = assetDescriptors;
    }

    @Override
    @GET
    public Page<ComponentXO> getComponents(@QueryParam(value="continuationToken") String continuationToken, @QueryParam(value="repository") String repositoryId) {
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryId);
        PageResult<Component> componentBrowseResult = this.browseService.browseComponents(repository, new QueryOptions(null, "id", "asc", Integer.valueOf(0), Integer.valueOf(10), this.lastIdFromContinuationToken(continuationToken)));
        List componentXOs = componentBrowseResult.getResults().stream().map(component -> this.fromComponent((Component)component, repository)).collect(Collectors.toList());
        return new Page(componentXOs, componentBrowseResult.getTotal() > (long)componentBrowseResult.getResults().size() ? this.continuationTokenHelper.getTokenFromId((Entity)Iterables.getLast((Iterable)componentBrowseResult.getResults())) : null);
    }

    @Nullable
    private String lastIdFromContinuationToken(String continuationToken) {
        try {
            return this.continuationTokenHelper.getIdFromToken(continuationToken);
        }
        catch (ContinuationTokenHelper.ContinuationTokenException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            throw new WebApplicationException(406);
        }
    }

    private ComponentXO fromComponent(Component component, Repository repository) {
        String internalId = EntityHelper.id((Entity)component).getValue();
        ComponentXO componentXO = this.componentXOFactory.createComponentXO();
        componentXO.setAssets(this.browseService.browseComponentAssets(repository, component.getEntityMetadata().getId().getValue()).getResults().stream().map(asset -> AssetXOBuilder.fromAsset(asset, repository, this.assetDescriptors)).collect(Collectors.toList()));
        componentXO.setGroup(component.group());
        componentXO.setName(component.name());
        componentXO.setVersion(component.version());
        componentXO.setId(new RepositoryItemIDXO(repository.getName(), internalId).getValue());
        componentXO.setRepository(repository.getName());
        componentXO.setFormat(repository.getFormat().getValue());
        for (ComponentsResourceExtension componentsResourceExtension : this.componentsResourceExtensions) {
            componentXO = componentsResourceExtension.updateComponentXO(componentXO, component);
        }
        return componentXO;
    }

    @Override
    @GET
    @Path(value="/{id}")
    public ComponentXO getComponentById(@PathParam(value="id") String id) {
        RepositoryItemIDXO repositoryItemXOID = RepositoryItemIDXO.fromString((String)id);
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryItemXOID.getRepositoryId());
        Component component = this.getComponent(repositoryItemXOID, repository);
        return this.fromComponent(component, repository);
    }

    private Component getComponent(RepositoryItemIDXO repositoryItemIDXO, Repository repository) {
        try {
            return Optional.ofNullable(this.browseService.getComponentById(this.componentEntityAdapter.recordIdentity((EntityId)new DetachedEntityId(repositoryItemIDXO.getId())), repository)).orElseThrow(() -> new NotFoundException("Unable to locate component with id " + repositoryItemIDXO.getValue()));
        }
        catch (IllegalArgumentException e) {
            this.log.debug("IllegalArgumentException caught retrieving component with id {}", (Object)repositoryItemIDXO.getId(), (Object)e);
            throw new WebApplicationException(String.format("Unable to process component with id %s", repositoryItemIDXO.getId()), 422);
        }
    }

    @Override
    @DELETE
    @Path(value="/{id}")
    public void deleteComponent(@PathParam(value="id") String id) {
        RepositoryItemIDXO repositoryItemIdXO = RepositoryItemIDXO.fromString((String)id);
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryItemIdXO.getRepositoryId());
        Component component = this.getComponent(repositoryItemIdXO, repository);
        if (repository != null && component != null) {
            this.maintenanceService.deleteComponent(repository, component);
        }
    }

    @Override
    @POST
    @Consumes(value={"multipart/form-data"})
    public void uploadComponent(@QueryParam(value="repository") String repositoryId, @Context HttpServletRequest request) throws IOException {
        if (!this.uploadConfiguration.isEnabled()) {
            throw new WebApplicationException(404);
        }
        if (request.getContentType() == null || !request.getContentType().startsWith("multipart/")) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)"\"Expected multipart Content-Type\"", "application/json");
        }
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryId);
        try {
            this.uploadManager.handle(repository, request);
        }
        catch (IllegalOperationException e) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }
}

