/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.cma;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.sonatype.nexus.repository.storage.Component;

public class ComponentResponseUtils {
    private static final String NAME = "name";
    private static final String GROUP = "group";
    private static final String VERSION = "version";

    private ComponentResponseUtils() {
    }

    public static Map<String, String> mapFor(Component component) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)NAME, (Object)component.name());
        ComponentResponseUtils.maybePut((ImmutableMap.Builder<String, String>)builder, component, Component::group, GROUP);
        ComponentResponseUtils.maybePut((ImmutableMap.Builder<String, String>)builder, component, Component::version, VERSION);
        return builder.build();
    }

    public static <T> void maybePut(ImmutableMap.Builder<String, String> builder, T t, Function<T, String> f, String key) {
        Optional.of(t).map(f).ifPresent(v -> {
            ImmutableMap.Builder builder2 = builder.put((Object)key, v);
        });
    }
}

