/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maintenance.internal;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.authz.AuthorizationException;
import org.joda.time.DateTime;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.MissingFacetException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maintenance.MaintenanceService;
import org.sonatype.nexus.repository.maintenance.internal.DeleteFolderService;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.RepositoryPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetVariableResolver;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentMaintenance;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
public class MaintenanceServiceImpl
implements MaintenanceService {
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final DeleteFolderService deleteFolderService;
    private final RepositoryPermissionChecker repositoryPermissionChecker;
    private final ExecutorService executorService;

    @Inject
    public MaintenanceServiceImpl(ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager, DeleteFolderService deleteFolderService, RepositoryPermissionChecker repositoryPermissionChecker) {
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.deleteFolderService = (DeleteFolderService)Preconditions.checkNotNull((Object)deleteFolderService);
        this.repositoryPermissionChecker = (RepositoryPermissionChecker)Preconditions.checkNotNull((Object)repositoryPermissionChecker);
        this.executorService = NexusExecutorService.forCurrentSubject((ExecutorService)Executors.newSingleThreadExecutor((ThreadFactory)new NexusThreadFactory("delete-path", "Delete path in Tree Browse View", 1)));
    }

    @Override
    public Set<String> deleteAsset(Repository repository, Asset asset) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)asset);
        if (!this.canDeleteAsset(repository, asset)) {
            throw new AuthorizationException();
        }
        return this.getComponentMaintenanceFacet(repository).deleteAsset(asset.getEntityMetadata().getId());
    }

    @Override
    public Set<String> deleteComponent(Repository repository, Component component) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)component);
        if (!this.canDeleteComponent(repository, component)) {
            throw new AuthorizationException();
        }
        return this.getComponentMaintenanceFacet(repository).deleteComponent(component.getEntityMetadata().getId());
    }

    @Override
    public void deleteFolder(Repository repository, String path) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)path);
        if (!this.canDeleteFolder(repository, path)) {
            throw new AuthorizationException();
        }
        this.executorService.submit(() -> this.deleteFolderService.deleteFolder(repository, path, DateTime.now(), () -> false));
    }

    @Override
    public boolean canDeleteComponent(Repository repository, Component component) {
        boolean canDeleteComponent = true;
        String repositoryFormat = repository.getFormat().toString();
        AssetVariableResolver assetVariableResolver = (AssetVariableResolver)this.variableResolverAdapterManager.get(repositoryFormat);
        Throwable throwable = null;
        Object var7_8 = null;
        try (StorageTx storageTx = ((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            storageTx.begin();
            for (Asset asset : storageTx.browseAssets(component)) {
                if (this.canDeleteAssetInRepository(repository, repositoryFormat, assetVariableResolver, asset)) continue;
                canDeleteComponent = false;
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return canDeleteComponent;
    }

    @Override
    public boolean canDeleteAsset(Repository repository, Asset asset) {
        String repositoryFormat = repository.getFormat().toString();
        return this.canDeleteAssetInRepository(repository, repositoryFormat, (AssetVariableResolver)this.variableResolverAdapterManager.get(repositoryFormat), asset);
    }

    private boolean canDeleteAssetInRepository(Repository repository, String repositoryFormat, AssetVariableResolver assetVariableResolver, Asset asset) {
        return this.contentPermissionChecker.isPermitted(repository.getName(), repositoryFormat, "delete", assetVariableResolver.fromAsset(asset));
    }

    @Override
    public boolean canDeleteFolder(Repository repository, String folder) {
        return this.repositoryPermissionChecker.userCanDeleteInRepository(repository);
    }

    private ComponentMaintenance getComponentMaintenanceFacet(Repository repository) {
        try {
            return (ComponentMaintenance)repository.facet(ComponentMaintenance.class);
        }
        catch (MissingFacetException e) {
            throw new IllegalOperationException(String.format("Deleting from repository %s of type %s is not supported", repository.getName(), repository.getFormat()), (Throwable)e);
        }
    }
}

