/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maintenance.internal;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.BooleanSupplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.node.BrowseNode;
import org.sonatype.nexus.repository.browse.node.BrowseNodeConfiguration;
import org.sonatype.nexus.repository.browse.node.BrowseNodeQueryService;
import org.sonatype.nexus.repository.maintenance.internal.DeleteFolderService;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetStore;
import org.sonatype.nexus.repository.storage.AssetVariableResolver;
import org.sonatype.nexus.repository.storage.ComponentMaintenance;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.security.SecurityHelper;

@Named
@Singleton
public class DeleteFolderServiceImpl
extends ComponentSupport
implements DeleteFolderService {
    private final BrowseNodeQueryService browseNodeQueryService;
    private final BrowseNodeConfiguration configuration;
    private final AssetStore assetStore;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final SecurityHelper securityHelper;

    @Inject
    public DeleteFolderServiceImpl(BrowseNodeQueryService browseNodeQueryService, BrowseNodeConfiguration configuration, AssetStore assetStore, ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager, SecurityHelper securityHelper) {
        this.browseNodeQueryService = (BrowseNodeQueryService)Preconditions.checkNotNull((Object)browseNodeQueryService);
        this.configuration = (BrowseNodeConfiguration)Preconditions.checkNotNull((Object)configuration);
        this.assetStore = (AssetStore)Preconditions.checkNotNull((Object)assetStore);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
    }

    @Override
    public void deleteFolder(Repository repository, String treePath, DateTime timestamp, BooleanSupplier cancelledCheck) {
        boolean canDeleteComponent = this.securityHelper.isPermitted(new Permission[]{new RepositoryViewPermission(repository, new String[]{"delete"})})[0];
        ComponentMaintenance componentMaintenance = (ComponentMaintenance)repository.facet(ComponentMaintenance.class);
        PriorityQueue<String> paths = new PriorityQueue<String>();
        paths.add(treePath);
        while (!cancelledCheck.getAsBoolean() && !paths.isEmpty()) {
            String basePath = (String)paths.poll();
            List<String> path = Arrays.asList(basePath.split("/"));
            Iterable nodes = this.browseNodeQueryService.getByPath(repository, path, this.configuration.getMaxNodes());
            Iterator nodeIterator = nodes.iterator();
            while (!cancelledCheck.getAsBoolean() && nodeIterator.hasNext()) {
                BrowseNode node = (BrowseNode)nodeIterator.next();
                if (!node.isLeaf()) {
                    paths.offer(String.valueOf(basePath) + "/" + node.getName());
                } else if (canDeleteComponent && node.getAssetId() == null && node.getComponentId() != null) {
                    this.deleteComponent(repository, node.getComponentId(), timestamp, componentMaintenance);
                }
                if (node.getAssetId() == null) continue;
                this.deleteAsset(repository, node.getAssetId(), timestamp, componentMaintenance);
            }
        }
    }

    private void deleteComponent(Repository repository, EntityId componentId, DateTime timestamp, ComponentMaintenance componentMaintenance) {
        Optional<DateTime> lastUpdated;
        Throwable throwable = null;
        Object var7_7 = null;
        try (StorageTx tx = ((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            lastUpdated = Optional.ofNullable(tx.findComponent(componentId)).map(component -> component.lastUpdated());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lastUpdated.ifPresent(lu -> {
            if (timestamp.isAfter((ReadableInstant)lu)) {
                componentMaintenance.deleteComponent(componentId);
            }
        });
    }

    private Optional<EntityId> deleteAsset(Repository repository, EntityId assetId, DateTime timestamp, ComponentMaintenance componentMaintenance) {
        EntityId componenetId = null;
        Asset asset = this.assetStore.getById(assetId);
        if (timestamp.isAfter((ReadableInstant)asset.blobCreated()) && this.canDeleteAsset(repository, asset)) {
            try {
                componentMaintenance.deleteAsset(assetId);
                componenetId = asset.componentId();
            }
            catch (Exception e) {
                this.log.error("Failed to delete an asset - skipping.", (Throwable)e);
            }
        }
        return Optional.ofNullable(componenetId);
    }

    private boolean canDeleteAsset(Repository repository, Asset asset) {
        AssetVariableResolver assetVariableResolver = (AssetVariableResolver)this.variableResolverAdapterManager.get(repository.getFormat().getValue());
        return this.contentPermissionChecker.isPermitted(repository.getName(), repository.getFormat().getValue(), "delete", assetVariableResolver.fromAsset(asset));
    }
}

