/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.time.DateHelper;
import org.sonatype.nexus.repository.storage.Asset;

public class CacheInfo {
    @VisibleForTesting
    public static final String CACHE = "cache";
    @VisibleForTesting
    public static final String CACHE_TOKEN = "cache_token";
    @VisibleForTesting
    public static final String LAST_VERIFIED = "last_verified";
    @VisibleForTesting
    public static final String INVALIDATED = "invalidated";
    private final DateTime lastVerified;
    @Nullable
    private final String cacheToken;

    public CacheInfo(DateTime lastVerified, @Nullable String cacheToken) {
        this.lastVerified = (DateTime)Preconditions.checkNotNull((Object)lastVerified);
        this.cacheToken = cacheToken;
    }

    public DateTime getLastVerified() {
        return this.lastVerified;
    }

    @Nullable
    public String getCacheToken() {
        return this.cacheToken;
    }

    public boolean isInvalidated() {
        return INVALIDATED.equals(this.cacheToken);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "lastVerified=" + this.lastVerified + ", cacheToken='" + this.cacheToken + '\'' + '}';
    }

    @Nullable
    public static CacheInfo extractFromAsset(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        NestedAttributesMap cache = asset.attributes().child(CACHE);
        DateTime lastVerified = DateHelper.toDateTime((Date)((Date)cache.get(LAST_VERIFIED, Date.class)));
        if (lastVerified == null) {
            return null;
        }
        String cacheToken = (String)cache.get(CACHE_TOKEN, String.class);
        return new CacheInfo(lastVerified, cacheToken);
    }

    @Nullable
    public static CacheInfo extractFromAsset(NestedAttributesMap attributes) {
        Preconditions.checkNotNull((Object)attributes);
        NestedAttributesMap cache = attributes.child(CACHE);
        DateTime lastVerified = DateHelper.toDateTime((Date)((Date)cache.get(LAST_VERIFIED, Date.class)));
        if (lastVerified == null) {
            return null;
        }
        String cacheToken = (String)cache.get(CACHE_TOKEN, String.class);
        return new CacheInfo(lastVerified, cacheToken);
    }

    public static void applyToAsset(Asset asset, CacheInfo cacheInfo) {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkNotNull((Object)cacheInfo);
        NestedAttributesMap cache = asset.attributes().child(CACHE);
        cache.set(LAST_VERIFIED, (Object)DateHelper.toDate((DateTime)cacheInfo.getLastVerified()));
        cache.set(CACHE_TOKEN, (Object)cacheInfo.getCacheToken());
    }

    public static boolean invalidateAsset(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        NestedAttributesMap cache = asset.attributes().child(CACHE);
        return !INVALIDATED.equals(cache.set(CACHE_TOKEN, (Object)INVALIDATED));
    }
}

