/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexCursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.internal.orient.OrientBrowseNodeManager;
import org.sonatype.nexus.repository.browse.node.BrowseNodeConfiguration;
import org.sonatype.nexus.repository.browse.node.RebuildBrowseNodeFailedException;
import org.sonatype.nexus.repository.browse.node.RebuildBrowseNodeService;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.AssetStore;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
@Priority(value=0x7FFFFFFF)
public class OrientRebuildBrowseNodeService
implements RebuildBrowseNodeService {
    private final Logger log = Loggers.getLogger((Object)this);
    private static final int BUCKET_KEY_ID = 0;
    private final AssetStore assetStore;
    private final BucketStore bucketStore;
    private final OrientBrowseNodeManager browseNodeManager;
    private final int rebuildPageSize;

    @Inject
    public OrientRebuildBrowseNodeService(AssetStore assetStore, BucketStore bucketStore, OrientBrowseNodeManager browseNodeManager, BrowseNodeConfiguration configuration) {
        this.assetStore = (AssetStore)Preconditions.checkNotNull((Object)assetStore);
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
        this.browseNodeManager = (OrientBrowseNodeManager)((Object)Preconditions.checkNotNull((Object)((Object)browseNodeManager)));
        this.rebuildPageSize = ((BrowseNodeConfiguration)Preconditions.checkNotNull((Object)configuration)).getRebuildPageSize();
    }

    public void rebuild(Repository repository, Consumer<String> progressUpdater) throws RebuildBrowseNodeFailedException {
        this.log.info("Deleting browse nodes for repository {}", (Object)repository.getName());
        this.browseNodeManager.deleteByRepository(repository.getName());
        this.log.info("Rebuilding browse nodes for repository {}", (Object)repository.getName());
        Bucket bucket = this.bucketStore.read(repository.getName());
        ORID bucketId = AttachedEntityHelper.id((Entity)bucket);
        try {
            long processed = 0L;
            long total = this.assetStore.countAssets((Iterable<Bucket>)ImmutableList.of((Object)((Object)bucket)));
            if (total > 0L) {
                ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);
                Stopwatch sw = Stopwatch.createStarted();
                OIndexCursor cursor = this.assetStore.getIndex(AssetEntityAdapter.I_BUCKET_COMPONENT_NAME).cursor();
                List nextPage = this.assetStore.getNextPage(cursor, this.rebuildPageSize);
                while (!Iterables.isEmpty(nextPage)) {
                    CancelableHelper.checkCancellation();
                    ArrayList<Asset> assets = new ArrayList<Asset>(this.rebuildPageSize);
                    for (Map.Entry indexEntry : nextPage) {
                        if (!bucketId.equals(((OCompositeKey)indexEntry.getKey()).getKeys().get(0))) continue;
                        assets.add(this.assetStore.getById(indexEntry.getValue()));
                    }
                    int assetsSize = Iterables.size(assets);
                    this.browseNodeManager.createFromAssets(repository, assets);
                    long elapsed = sw.elapsed(TimeUnit.MILLISECONDS);
                    progressLogger.info("Rebuilt browse nodes for {} / {} assets in {} ms", new Object[]{processed += (long)assetsSize, total, elapsed});
                    if (progressUpdater != null) {
                        long percentageComplete = BigDecimal.valueOf(processed).divide(BigDecimal.valueOf(total), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).longValue();
                        progressUpdater.accept(String.format("%d%% Complete", percentageComplete));
                    }
                    nextPage = this.assetStore.getNextPage(cursor, this.rebuildPageSize);
                }
                progressLogger.flush();
            }
        }
        catch (Exception e) {
            throw new RebuildBrowseNodeFailedException("Could not re-create browse nodes", (Throwable)e);
        }
    }
}

